package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端费用
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "终端费用")
@Slf4j
@RestController
@RequestMapping("/v1/cost/terminal")
public class CostTerminalController {

  @Autowired
  private CostTerminalService costTerminalService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostTerminalEntity>> findByConditions(@ApiParam(name = "costTerminalDto", value = "终端分页Dto") CostTerminalDto costTerminalDto,
                                                           @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostTerminalEntity> result = this.costTerminalService.findByConditions(costTerminalDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据编码查询
   * @return
   */
  @ApiOperation(value = "根据编码查询")
  @GetMapping("findByTerminalCode")
  public Result<CostTerminalEntity> findByTerminalCode(@RequestParam(value = "") @ApiParam(name = "terminalCode", value = "终端编码") String terminalCode) {
    try {
      CostTerminalEntity result = this.costTerminalService.findByTerminalCode(terminalCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据当前登陆人编码查询
   * @return
   */
  @ApiOperation(value = "根据当前登陆人编码查询")
  @GetMapping("findByCurrentUser")
  public Result<CostTerminalEntity> findByCurrentUser() {
    try {
      LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      CostTerminalEntity result = this.costTerminalService.findByTerminalCode(userDetails.getConsumerCode());
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
