package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端费用明细
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "终端费用明细")
@Slf4j
@RestController
@RequestMapping("/v1/cost/terminalDetail")
public class CostTerminalDetailController {

  @Autowired
  private CostTerminalDetailService costTerminalDetailService;

  /**
   * 根据终端费用id查询明细
   * @return
   */
  @ApiOperation(value = "根据终端费用id查询明细")
  @GetMapping("findByCostTerminalId")
  public Result<Page<CostTerminalDetailEntity>> findByCostTerminalId(@ApiParam(name = "costTerminalId", value = "终端费用id") String costTerminalId,
                                                                     @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostTerminalDetailEntity> result = this.costTerminalDetailService.findByCostTerminalId(costTerminalId, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
