package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostTerminalDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端费用明细
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "终端费用明细")
@Slf4j
@RestController
@RequestMapping("/v1/cost/terminalDetail")
public class CostTerminalDetailVoController {

  @Autowired
  private CostTerminalDetailVoService costTerminalDetailVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostTerminalDetailVo>> findByConditions(@ApiParam(name = "costDealerDetailDto", value = "终端分页Dto") CostTerminalDetailDto costTerminalDetailDto,
                                                             @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostTerminalDetailVo> result = this.costTerminalDetailVoService.findByConditions(costTerminalDetailDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
