package com.biz.crm.cps.business.reward.cost.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 经销商货补上账
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostDealerBillDetailEntity", description = "经销商货补上账")
@TableName("cost_dealer_bill_detail")
public class CostDealerBillDetailEntity extends UuidEntity {
  private static final long serialVersionUID = 8190467636664597283L;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  @TableField(value = "material_name")
  private String materialName;

  /**
   * 支付类型
   */
  @ApiModelProperty("支付类型")
  @TableField(value = "pay_type")
  private String payType;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  private String productLevelCode;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_name")
  private String productLevelName;

  /**
   * 本次费用
   */
  @ApiModelProperty("本次费用")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 上账id
   */
  @ApiModelProperty("上账id")
  @TableField(value = "cost_dealer_bill_id")
  private String costDealerBillId;

  /**
   * 上账信息
   */
  @ApiModelProperty("上账信息")
  @TableField(exist = false)
  private CostDealerDetailEntity bill;

}
