package com.biz.crm.cps.business.reward.cost.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

/** 经销商费用明细 @Author: zengxingwang @Date: 2021/8/5 10:32 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostDealerDetailEntity", description = "经销商费用明细")
@TableName("cost_dealer_detail")
public class CostDealerDetailEntity extends UuidOpEntity {
  private static final long serialVersionUID = 8190467636664597283L;

  /** 费用变动流水编码 */
  @ApiModelProperty("费用变动流水编码")
  @TableField(value = "code")
  private String code;

  /** 业务类型 = 触发动作 */
  @ApiModelProperty("业务类型")
  @TableField(value = "source_type")
  private String sourceType;

  /** 业务来源编号 = 触发对象 */
  @ApiModelProperty("业务来源编号")
  @TableField(value = "source_code")
  private String sourceCode;

  /** 分利费用 */
  @ApiModelProperty("分利费用")
  @TableField(value = "amount")
  private BigDecimal amount;

  /** 已上账费用 */
  @ApiModelProperty("已上账费用")
  @TableField(value = "billed_fee")
  private BigDecimal billedFee;

  /** 未上账费用 */
  @ApiModelProperty("未上账费用")
  @TableField(value = "unbilled_fee")
  private BigDecimal unBilledFee;

  /** 上账状态（1.已上账2.未上账） */
  @ApiModelProperty("上账状态（1.已上账2.未上账3.部分核销）")
  @TableField(value = "bill_state")
  private Integer billState;

  /** 备注 */
  @ApiModelProperty("备注")
  @TableField(value = "remark")
  private String remark;

  /** 经销商费用id */
  @ApiModelProperty("经销商费用id")
  @TableField(value = "cost_dealer_id")
  private String costDealerId;

  /** 协议编码 */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;

  /** 扫码记录编码 */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  private String recordCode;

  /** 收/支（1.收2.支） */
  @ApiModelProperty("收/支（1.收2.支）")
  @TableField(value = "in_or_out")
  private Integer inOrOut;

  /** 触发动作所属政策 */
  @ApiModelProperty(value = "政策名称")
  @TableField("policy_name")
  private String policyName;

  /** 模板编码 */
  @ApiModelProperty(value = "模板编码")
  @TableField("template_code")
  private String templateCode;

  /** 经销商费用信息 */
  @ApiModelProperty("经销商费用信息")
  @TableField(exist = false)
  private CostDealerEntity dealer;

  /** 经销商编码 */
  @ApiModelProperty("经销商编码")
  @TableField(value = "dealer_code")
  private String dealerCode;

  /** 费用类型（1.分利；2.上账；3、兑换） */
  @ApiModelProperty("费用类型（1.分利；2.上账；3、兑换）")
  @TableField(value = "cost_type")
  private Integer costType;

  /** 上账类型（1.货补2.折扣） */
  @ApiModelProperty("上账类型（1.货补2.折扣）")
  @TableField(value = "bill_type")
  private Integer billType;

  /** 总上账费用金额 */
  @ApiModelProperty("总上账费用金额")
  @TableField(value = "total_fee")
  private BigDecimal totalFee;

  /** 货补上账明细 */
  @ApiModelProperty("货补上账明细")
  @TableField(exist = false)
  private Set<CostDealerBillDetailEntity> billDetail;

  /** 返利类型 (正向，反向) */
  @ApiModelProperty("返利类型 (正向，反向)")
  @TableField(value = "rebate_type")
  private String rebateType;

  /**
   * 关联业务类型
   *
   * @see RewardRelateTypeEnum dictCode
   */
  @ApiModelProperty("关联业务类型")
  @TableField(value = "relate_type")
  private String relateType;

  /** 关联业务流号 协议活动号、扫码活动编码 */
  @ApiModelProperty("关联业务流号-协议活动号、扫码活动编码")
  @TableField(value = "relate_code")
  private String relateCode;
}
