package com.biz.crm.cps.business.reward.cost.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 经销商费用
 *
 * @Author: zengxingwang
 * @Date: 2021/8/5 10:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostDealerEntity", description = "经销商费用")
@TableName("cost_dealer")
public class CostDealerEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 8190467636664597283L;

  /**
   * 经销商编码
   */
  @ApiModelProperty("经销商编码")
  @TableField(value = "dealer_code")
  private String dealerCode;

  /**
   * 经销商名称
   */
  @ApiModelProperty("经销商名称")
  @TableField(value = "dealer_name")
  private String dealerName;

  /**
   * 渠道类型
   */
  @ApiModelProperty("渠道类型")
  @TableField(value = "channel")
  private String channel;

  /**
   * 电话号码
   */
  @ApiModelProperty("电话号码")
  @TableField(value = "phone")
  private String phone;

  /**
   * 客户标签
   */
  @ApiModelProperty("客户标签")
  @TableField(value = "tag")
  private String tag;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;

  /**
   * 分利总金额
   */
  @ApiModelProperty("分利总金额")
  @TableField(value = "total_amount")
  private BigDecimal totalAmount;

  /**
   * 终端流转费用
   */
  @ApiModelProperty("终端流转费用")
  @TableField(value = "terminal_circulation_fee")
  private BigDecimal terminalCirculationFee;

  /**
   * 已上账费用
   */
  @ApiModelProperty("已上账费用")
  @TableField(value = "billed_fee")
  private BigDecimal billedFee;

  /**
   * 未上账费用
   */
  @ApiModelProperty("未上账费用")
  @TableField(value = "unbilled_fee")
  private BigDecimal unBilledFee;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @TableField(value = "province_code")
  private String provinceCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  @TableField(value = "province_name")
  private String provinceName;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @TableField(value = "city_code")
  private String cityCode;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  @TableField(value = "city_name")
  private String cityName;

  /**
   * 区/县编码
   */
  @ApiModelProperty("区/县编码")
  @TableField(value = "district_code")
  private String districtCode;

  /**
   * 区/县名称
   */
  @ApiModelProperty("区/县名称")
  @TableField(value = "district_name")
  private String districtName;

  /**
   * 经销商费用明细
   */
  @ApiModelProperty("经销商费用明细")
  @TableField(exist = false)
  private Set<CostDealerDetailEntity> dealerDetail;
}
