package com.biz.crm.cps.business.reward.cost.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/** 终端费用明细 @Author: zengxingwang @Date: 2021/8/5 10:32 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostTerminalDetailEntity", description = "终端费用明细")
@TableName("cost_terminal_detail")
public class CostTerminalDetailEntity extends UuidOpEntity {
  private static final long serialVersionUID = 8190467636664597283L;

  /** 费用变动流水编码 */
  @ApiModelProperty("费用变动流水编码")
  @TableField(value = "code")
  private String code;

  /** 业务类型 = 触发动作 */
  @ApiModelProperty("业务类型")
  @TableField(value = "source_type")
  private String sourceType;

  /** 业务来源编号 = 触发对象 */
  @ApiModelProperty("业务来源编号")
  @TableField(value = "source_code")
  private String sourceCode;

  /** 分利费用 */
  @ApiModelProperty("分利费用")
  @TableField(value = "amount")
  private BigDecimal amount;

  /** 已核销费用 */
  @ApiModelProperty("已核销费用")
  @TableField(value = "audited_fee")
  private BigDecimal auditedFee;

  /** 未核销费用 */
  @ApiModelProperty("未核销费用")
  @TableField(value = "unaudit_fee")
  private BigDecimal unAuditFee;

  /** 核销状态(1.未核销，2.部分核销3.已核销) */
  @ApiModelProperty("核销状态(1.未核销，2.部分核销3.已核销)")
  @TableField(value = "audit_state")
  private Integer auditState;

  /** 备注 */
  @ApiModelProperty("备注")
  @TableField(value = "remark")
  private String remark;

  /** 终端费用id */
  @ApiModelProperty("终端费用id")
  @TableField(value = "cost_terminal_id")
  private String costTerminalId;

  /** 协议编码 */
  @ApiModelProperty("协议编码")
  @TableField(value = "agreement_code")
  private String agreementCode;

  /** 扫码记录编码 */
  @ApiModelProperty("扫码记录编码")
  @TableField(value = "record_code")
  private String recordCode;

  /** 收/支（1.收2.支） */
  @ApiModelProperty("收/支（1.收2.支）")
  @TableField(value = "in_or_out")
  private Integer inOrOut;

  /** 触发动作所属政策 */
  @ApiModelProperty(value = "政策名称")
  @TableField("policy_name")
  private String policyName;

  /** 模板编码 */
  @ApiModelProperty(value = "模板编码")
  @TableField("template_code")
  private String templateCode;

  /** 终端费用信息 */
  @ApiModelProperty("终端费用信息")
  @TableField(exist = false)
  private CostTerminalEntity terminal;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  private String terminalCode;

  /** 审核状态(1.待审核2.通过3.驳回) */
  @ApiModelProperty("审核状态(1.待审核2.通过3.驳回)")
  @TableField(value = "review_status")
  private Integer reviewStatus;

  /** 提交时间 */
  @ApiModelProperty("提交时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @TableField(value = "submit_time")
  private Date submitTime;

  /** 审核时间 */
  @ApiModelProperty("审核时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @TableField(value = "audit_time")
  private Date auditTime;

  /** 驳回时间 */
  @ApiModelProperty("驳回时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @TableField(value = "reject_time")
  private Date rejectTime;

  /** 费用类型（1.分利；2.上账） */
  @ApiModelProperty("费用类型（1.分利；2.上账）")
  @TableField(value = "cost_type")
  private Integer costType;

  /** 返利类型 (正向，反向) */
  @ApiModelProperty("返利类型 (正向，反向)")
  @TableField(value = "rebate_type")
  private String rebateType;

  /**
   * 关联业务类型
   *
   * @see RewardRelateTypeEnum dictCode
   */
  @ApiModelProperty("关联业务类型")
  @TableField(value = "relate_type")
  private String relateType;

  /** 关联业务流号 协议活动号、扫码活动编码 */
  @ApiModelProperty("关联业务流号-协议活动号、扫码活动编码")
  @TableField(value = "relate_code")
  private String relateCode;
}
