package com.biz.crm.cps.business.reward.cost.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 20211 10:42
 */
public interface CostDealerDetailMapper extends BaseMapper<CostDealerDetailEntity> {

  /**
   * 多条件分页查询
   * @param costDealerId
   * @param page
   * @return
   */
  Page<CostDealerDetailEntity> findByCostDealerId(@Param("costDealerId") String costDealerId, Page<CostDealerDetailEntity> page);

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  BigDecimal sumByParticipatorCodeAndRecordCodes(@Param("participatorCode") String participatorCode, @Param("recordCodes") List<String> recordCodes);

  /**
   * 按 租户和类型 汇总获得分利
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  BigDecimal sumByTenantCodeAndTriggerAction(@Param("tenantCode") String tenantCode, @Param("triggerAction") String triggerAction);
}
