package com.biz.crm.cps.business.reward.cost.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/2 15:29
 */
public interface CostDetailVoMapper {

  /**
   * 根据参与者编码、时间，收支类型查询终端分利明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  Page<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndTerminal(@Param("participatorCode") String participatorCode, @Param("yearAndMonth") String yearAndMonth, @Param("type") Integer type, Page<CostDetailVo> page);

  /**
   * 根据参与者编码、时间，收支类型查询终端核销明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  List<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndBillTerminal(@Param("participatorCode") String participatorCode, @Param("yearAndMonth") String yearAndMonth, @Param("type") Integer type);

  /**
   * 根据参与者编码、时间，收支类型查询经销商分利明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  Page<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndDealer(@Param("participatorCode") String participatorCode, @Param("yearAndMonth") String yearAndMonth, @Param("type") Integer type, Page<CostDetailVo> page);

  /**
   * 根据参与者编码、时间，收支类型查询经销商上账明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  List<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndBillDealer(@Param("participatorCode") String participatorCode, @Param("yearAndMonth") String yearAndMonth, @Param("type") Integer type);
}
