package com.biz.crm.cps.business.reward.cost.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 20211 10:42
 */
public interface CostTerminalDetailMapper extends BaseMapper<CostTerminalDetailEntity> {

  /**
   * 多条件分页查询
   * @param costTerminalId
   * @param page
   * @return
   */
  Page<CostTerminalDetailEntity> findByCostTerminalId(@Param("costTerminalId") String costTerminalId, Page<CostTerminalDetailEntity> page);

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  BigDecimal sumByParticipatorCodeAndRecordCodes(@Param("participatorCode") String participatorCode, @Param("recordCodes") List<String> recordCodes);

  /**
   * 按 租户和类型 汇总获得分利
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  BigDecimal sumByTenantCodeAndTriggerAction(@Param("tenantCode") String tenantCode, @Param("triggerAction") String triggerAction);
}
