package com.biz.crm.cps.business.reward.cost.local.repository;


import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerAgreementRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalAgreementRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.AgreementRewardStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hecheng
 * @description: 协议统计汇总收益
 * @date 2021/8/27 下午7:52
 */
@Component
public class CostAgreementRewardStatisticsVoRepository {

  @Autowired
  private CostDealerAgreementRewardStatisticsVoMapper costDealerAgreementRewardStatisticsVoMapper;
  @Autowired
  private CostTerminalAgreementRewardStatisticsVoMapper costTerminalAgreementRewardStatisticsVoMapper;

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCode
   * @param agreementCodes
   * @return
   */
  public List<AgreementRewardStatisticsVo> findByParticipatorCodeAndAgreementCodes(String participatorCode, List<String> agreementCodes) {
    List<AgreementRewardStatisticsVo> result = new ArrayList<>();
    List<AgreementRewardStatisticsVo> dealer = costDealerAgreementRewardStatisticsVoMapper.findByParticipatorCodeAndAgreementCodes(participatorCode, agreementCodes);
    if(!CollectionUtils.isEmpty(dealer)){
      result.addAll(dealer);
    }
    List<AgreementRewardStatisticsVo> terminal = costTerminalAgreementRewardStatisticsVoMapper.findByParticipatorCodeAndAgreementCodes(participatorCode, agreementCodes);
    if(!CollectionUtils.isEmpty(terminal)){
      result.addAll(terminal);
    }
    return result;
  }
}
