package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:38
 */
@Component
public class CostDealerDetailRepository extends ServiceImpl<CostDealerDetailMapper, CostDealerDetailEntity> {

  @Autowired
  private CostDealerDetailMapper costDealerDetailMapper;
  /**
   * 多条件分页查询
   * @param costDealerId
   * @param pageable
   * @return
   */
  public Page<CostDealerDetailEntity> findByCostDealerId(String costDealerId, Pageable pageable) {
    Page<CostDealerDetailEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costDealerDetailMapper.findByCostDealerId(costDealerId, page);
  }

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
    return this.costDealerDetailMapper.sumByParticipatorCodeAndRecordCodes(participatorCode,recordCodes);
  }

  /**
   * 按 租户和类型 汇总获得分利
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  public BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
    return this.costDealerDetailMapper.sumByTenantCodeAndTriggerAction(tenantCode,triggerAction);
  }
}
