package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerDetailVoMapper;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDealerDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 经销商费用明细实现持久化
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:39
 */
@Component
public class CostDealerDetailVoRepository {

  @Autowired
  private CostDealerDetailVoMapper costDealerDetailVoMapper;
  /**
   * 多条件分页查询
   * @param costDealerDetailDto
   * @param pageable
   * @return
   */
  public Page<CostDealerDetailVo> findByConditions(CostDealerDetailDto costDealerDetailDto, Pageable pageable) {
    Page<CostDealerDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costDealerDetailVoMapper.findByConditions(costDealerDetailDto, page);
  }
}
