package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerMapper;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:38
 */
@Component
public class CostDealerRepository extends ServiceImpl<CostDealerMapper, CostDealerEntity> {

  @Autowired
  private CostDealerMapper costDealerMapper;
  /**
   * 多条件分页查询
   * @param costDealerDto
   * @param pageable
   * @return
   */
  public Page<CostDealerEntity> findByConditions(CostDealerDto costDealerDto, Pageable pageable) {
    Page<CostDealerEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costDealerMapper.findByConditions(costDealerDto, page);
  }

  /**
   * 根据经销商编码查询
   * @param dealerCode
   * @return
   */
  public CostDealerEntity findByDealerCode(String dealerCode) {
    QueryWrapper<CostDealerEntity> wrapper = new QueryWrapper();
    wrapper.eq("dealer_code", dealerCode);
    return this.getOne(wrapper);
  }

  /**
   * 根据参与者编码查询最新一条流水信息
   *
   * @param dealerCode
   * @return
   */
  public CostDealerEntity findTop1ByDealerCode(String dealerCode) {
    return this.costDealerMapper.findTop1ByDealerCode(dealerCode);
  }
}
