package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostDetailVoMapper;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/2 15:24
 */
@Component
public class CostDetailVoRepository {

  @Autowired
  private CostDetailVoMapper costDetailVoMapper;

  /**
   * 根据参与者编码、时间，收支类型查询终端分利明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  public Page<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndTerminal(String participatorCode, String yearAndMonth, Integer type, Pageable pageable) {
    Page<CostDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costDetailVoMapper.findByParticipatorCodeAndTimeAndTypeAndTerminal(participatorCode, yearAndMonth, type, page);
  }

  /**
   * 根据参与者编码、时间，收支类型查询终端核销明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  public List<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndBillTerminal(String participatorCode, String yearAndMonth, Integer type) {
    return costDetailVoMapper.findByParticipatorCodeAndTimeAndTypeAndBillTerminal(participatorCode, yearAndMonth, type);
  }

  /**
   * 根据参与者编码、时间，收支类型查询经销商分利明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  public Page<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndDealer(String participatorCode, String yearAndMonth, Integer type, Pageable pageable) {
    Page<CostDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costDetailVoMapper.findByParticipatorCodeAndTimeAndTypeAndDealer(participatorCode, yearAndMonth, type, page);
  }

  /**
   * 根据参与者编码、时间，收支类型查询经销商上账明细信息
   * @param participatorCode
   * @param yearAndMonth
   * @param type
   * @return
   */
  public List<CostDetailVo> findByParticipatorCodeAndTimeAndTypeAndBillDealer(String participatorCode, String yearAndMonth, Integer type) {
    return costDetailVoMapper.findByParticipatorCodeAndTimeAndTypeAndBillDealer(participatorCode, yearAndMonth, type);
  }
}
