package com.biz.crm.cps.business.reward.cost.local.repository;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerParticipatorRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalParticipatorRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 参与者统计汇总收益
 * @date 2021/8/27 下午7:52
 */
@Component
public class CostParticipatorRewardStatisticsVoRepository {

  @Autowired
  private CostDealerParticipatorRewardStatisticsVoMapper
      costDealerParticipatorRewardStatisticsVoMapper;

  @Autowired
  private CostTerminalParticipatorRewardStatisticsVoMapper
      costTerminalParticipatorRewardStatisticsVoMapper;

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCodes
   * @return
   */
  public List<ParticipatorRewardStatisticsVo> findByParticipatorCodes(
      List<String> participatorCodes) {
    List<ParticipatorRewardStatisticsVo> result = new ArrayList<>();
    List<ParticipatorRewardStatisticsVo> dealer =
        this.costDealerParticipatorRewardStatisticsVoMapper.findByParticipatorCodes(
            participatorCodes);
    String today = DateUtil.today();
    if (!CollectionUtils.isEmpty(dealer)) {
      List<ParticipatorRewardStatisticsVo> todayAmount =
          this.costDealerParticipatorRewardStatisticsVoMapper.findTodayAmountByParticipatorCodes(
              participatorCodes, today, "扫");
      Map<String, BigDecimal> map = this.findTodayAmountMap(todayAmount);
      for (ParticipatorRewardStatisticsVo item : dealer) {
        item.setTodayAmount(map.getOrDefault(item.getParticipatorCode(), BigDecimal.ZERO));
      }
      result.addAll(dealer);
    }
    List<ParticipatorRewardStatisticsVo> terminal =
        this.costTerminalParticipatorRewardStatisticsVoMapper.findByParticipatorCodes(
            participatorCodes);
    if (!CollectionUtils.isEmpty(terminal)) {
      List<ParticipatorRewardStatisticsVo> todayAmount =
          this.costTerminalParticipatorRewardStatisticsVoMapper.findTodayAmountByParticipatorCodes(
              participatorCodes, today);
      Map<String, BigDecimal> map = this.findTodayAmountMap(todayAmount);
      for (ParticipatorRewardStatisticsVo item : terminal) {
        item.setTodayAmount(map.getOrDefault(item.getParticipatorCode(), BigDecimal.ZERO));
      }
      result.addAll(terminal);
    }
    return result;
  }

  /**
   * 获取当天收益map数据
   *
   * @param todayAmount
   * @return
   */
  private Map<String, BigDecimal> findTodayAmountMap(
      List<ParticipatorRewardStatisticsVo> todayAmount) {
    if (CollectionUtils.isEmpty(todayAmount)) {
      return Maps.newHashMap();
    }
    return todayAmount.stream()
        .filter(
            a ->
                StringUtils.isNotBlank(a.getParticipatorCode())
                    && Objects.nonNull(a.getTodayAmount()))
        .collect(
            Collectors.toMap(
                ParticipatorRewardStatisticsVo::getParticipatorCode,
                ParticipatorRewardStatisticsVo::getTodayAmount,
                (a, b) -> a));
  }
}
