package com.biz.crm.cps.business.reward.cost.local.repository;


import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerScanCodeRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalScanCodeRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hecheng
 * @description: 扫码统计汇总收益
 * @date 2021/8/27 下午7:52
 */
@Component
public class CostScanCodeRewardStatisticsVoRepository {

  @Autowired
  private CostDealerScanCodeRewardStatisticsVoMapper costDealerScanCodeRewardStatisticsVoMapper;
  @Autowired
  private CostTerminalScanCodeRewardStatisticsVoMapper costTerminalScanCodeRewardStatisticsVoMapper;
  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   *
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  public List<ScanCodeRewardStatisticsVo> findByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
    List<ScanCodeRewardStatisticsVo> list = new ArrayList<>();
    List<ScanCodeRewardStatisticsVo> dealer = costDealerScanCodeRewardStatisticsVoMapper.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    if(!CollectionUtils.isEmpty(dealer)){
      list.addAll(dealer);
    }
    List<ScanCodeRewardStatisticsVo> terminal = costTerminalScanCodeRewardStatisticsVoMapper.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    if(!CollectionUtils.isEmpty(terminal)){
      list.addAll(terminal);
    }
    return list;
  }
}
