package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalBillMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:38
 */
@Component
public class CostTerminalBillRepository extends ServiceImpl<CostTerminalBillMapper, CostTerminalDetailEntity> {

  @Autowired
  private CostTerminalBillMapper costTerminalBillMapper;

  public Page<CostTerminalDetailEntity> findByReviewStatusAndTerminalCodes(Integer reviewStatus, List<String> terminalCodes, Pageable pageable) {
    Page<CostTerminalDetailEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costTerminalBillMapper.findByReviewStatusAndTerminalCodes(reviewStatus, terminalCodes, page);
  }

  public BigDecimal sumByReviewStatusAndTerminalCode(int reviewStatus, String terminalCode) {
    return costTerminalBillMapper.sumByReviewStatusAndTerminalCode(reviewStatus, terminalCode);
  }
}
