package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalDetailVoMapper;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostTerminalDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 终端费用明细持久化
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:39
 */
@Component
public class CostTerminalDetailVoRepository {

  @Autowired
  private CostTerminalDetailVoMapper costTerminalDetailVoMapper;
  /**
   * 多条件分页查询
   * @param dto
   * @param pageable
   * @return
   */
  public Page<CostTerminalDetailVo> findByConditions(CostTerminalDetailDto dto, Pageable pageable) {
    Page<CostTerminalDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costTerminalDetailVoMapper.findByConditions(dto, page);
  }
}
