package com.biz.crm.cps.business.reward.cost.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalMapper;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:38
 */
@Component
public class CostTerminalRepository extends ServiceImpl<CostTerminalMapper, CostTerminalEntity> {

  @Autowired
  private CostTerminalMapper costTerminalMapper;
  /**
   * 多条件分页查询
   * @param costTerminalDto
   * @param pageable
   * @return
   */
  public Page<CostTerminalEntity> findByConditions(CostTerminalDto costTerminalDto, Pageable pageable) {
    Page<CostTerminalEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return costTerminalMapper.findByConditions(costTerminalDto, page);
  }

  /**
   * 根据编码查询
   * @param terminalCode
   * @return
   */
  public CostTerminalEntity findByTerminalCode(String terminalCode) {
    QueryWrapper<CostTerminalEntity> wrapper = new QueryWrapper();
    wrapper.eq("terminal_code", terminalCode);
    return this.getOne(wrapper);
  }

  public CostTerminalEntity findTop1ByTerminalCode(String terminalCode) {
    return this.costTerminalMapper.findTop1ByTerminalCode(terminalCode);
  }
}
