package com.biz.crm.cps.business.reward.cost.local.repository;

import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerTriggerObjectStatisticsVoMapper;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalTriggerObjectStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 费用触发对象奖励统计
 *
 * @author hecheng
 * @date 2021/09/02
 */
@Component
public class CostTriggerObjectStatisticsVoRepository {

  @Autowired
  private CostDealerTriggerObjectStatisticsVoMapper dealerTriggerObjectStatisticsVoMapper;
  @Autowired
  private CostTerminalTriggerObjectStatisticsVoMapper terminalTriggerObjectStatisticsVoMapper;

  /**
   *费用触发对象奖励统计
   * @param triggerAction
   * @param triggerObjects
   * @return
   */
  public List<TriggerObjectRewardStatisticsVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects){
    List<TriggerObjectRewardStatisticsVo> list = new ArrayList<>();
    List<TriggerObjectRewardStatisticsVo> dealerList = this.dealerTriggerObjectStatisticsVoMapper.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
    if(!CollectionUtils.isEmpty(dealerList)){
      list.addAll(dealerList);
    }
    List<TriggerObjectRewardStatisticsVo> terminalList = this.terminalTriggerObjectStatisticsVoMapper.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
    if(!CollectionUtils.isEmpty(terminalList)){
      list.addAll(terminalList);
    }
    return list;
  }
}
