package com.biz.crm.cps.business.reward.cost.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/23 16:33
 */
public interface CostDealerDetailService {

  /**
   * 根据经销商费用id查询明细
   * @param costDealerId
   * @param pageable
   * @return
   */
  Page<CostDealerDetailEntity> findByCostDealerId(String costDealerId, Pageable pageable);

  /**
   * 创建
   * @param dealerDetailEntity
   * @return
   */
  CostDealerDetailEntity create(CostDealerDetailEntity dealerDetailEntity);

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes);

  /**
   * 按 租户和类型 汇总获得分利
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction);

  /**
   * 修改
   * @param detail
   */
  void update(CostDealerDetailEntity detail);
}
