package com.biz.crm.cps.business.reward.cost.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDto;
import org.springframework.data.domain.Pageable;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:32
 */
public interface CostDealerService {

  /**
   * 多条件分页查询
   * @param costDealerDto
   * @param pageable
   * @return
   */
  Page<CostDealerEntity> findByConditions(CostDealerDto costDealerDto, Pageable pageable);

  /**
   * 根据经销商编码查询
   * @param dealerCode
   * @return
   */
  CostDealerEntity findByDealerCode(String dealerCode);

  /**
   * 修改
   * @param old
   */
  CostDealerEntity update(CostDealerEntity old);

  /**
   * 创建
   * @param dealer
   * @return
   */
  CostDealerEntity create(CostDealerEntity dealer);

  CostDealerEntity findTop1ByDealerCode(String dealerCode);
}
