package com.biz.crm.cps.business.reward.cost.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:32
 */
public interface CostTerminalBillService {

  /**
   * 创建上账
   * @param terminalBillEntity
   * @return
   */
  CostTerminalDetailEntity create(CostTerminalDetailEntity terminalBillEntity);

  /**
   * 根据经销商编码查询
   * @param dealerCode
   * @param reviewStatus
   * @param pageable
   * @return
   */
  Page<CostTerminalDetailEntity> findByDealerCode(String dealerCode, Integer reviewStatus, Pageable pageable);

  /**
   * 批量审批
   * @param ids
   */
  void approve(List<String> ids, Integer reviewStatus, String dealerCode);
}
