package com.biz.crm.cps.business.reward.cost.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/23 16:33
 */
public interface CostTerminalDetailService {

  /**
   * 根据经销商费用id查询明细
   * @param costTerminalId
   * @param pageable
   * @return
   */
  Page<CostTerminalDetailEntity> findByCostTerminalId(String costTerminalId, Pageable pageable);

  /**
   * 创建
   * @param terminalDetailEntity
   */
  CostTerminalDetailEntity create(CostTerminalDetailEntity terminalDetailEntity);

  /**
   * 按 参与者code 和扫码code集合汇总获得的分利
   * @param participatorCode
   * @param recordCodes
   * @return
   */
  BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes);

  /**
   * 按 租户和类型 汇总获得分利
   * @param tenantCode
   * @param triggerAction
   * @return
   */
  BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction);

  /**
   * 修改
   * @param detail
   */
  void update(CostTerminalDetailEntity detail);
}
