package com.biz.crm.cps.business.reward.cost.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDto;
import org.springframework.data.domain.Pageable;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:32
 */
public interface CostTerminalService {

  /**
   * 多条件分页查询
   * @param costTerminalDto
   * @param pageable
   * @return
   */
  Page<CostTerminalEntity> findByConditions(CostTerminalDto costTerminalDto, Pageable pageable);

  /**
   * 根据编码查询
   * @param terminalCode
   * @return
   */
  CostTerminalEntity findByTerminalCode(String terminalCode);

  /**
   * 创建
   * @param terminal
   * @return
   */
  CostTerminalEntity create(CostTerminalEntity terminal);

  /**
   * 修改
   * @param old
   */
  CostTerminalEntity update(CostTerminalEntity old);

  CostTerminalEntity findTop1ByTerminalCode(String terminalCode);
}
