package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.biz.crm.cps.business.reward.cost.local.repository.CostAgreementRewardStatisticsVoRepository;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostAgreementRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.AgreementRewardStatisticsVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author hecheng
 * @description: 协议统计汇总收益
 * @date 2021/8/27 下午7:47
 */
@Service("CostAgreementRewardStatisticsVoServiceImpl")
public class CostAgreementRewardStatisticsVoServiceImpl implements CostAgreementRewardStatisticsVoService {

  @Autowired
  private CostAgreementRewardStatisticsVoRepository costAgreementRewardStatisticsVoRepository;

  @Override
  public List<AgreementRewardStatisticsVo> findByParticipatorCodeAndAgreementCodes(String participatorCode, List<String> agreementCodes) {
    if (StringUtils.isBlank(participatorCode) || CollectionUtils.isEmpty(agreementCodes)) {
      return null;
    }
    return this.costAgreementRewardStatisticsVoRepository.findByParticipatorCodeAndAgreementCodes(participatorCode, agreementCodes);
  }
}
