package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerBillDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerBillDetailRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillDetailService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Set;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/23 17:33
 */
@Service
@Slf4j
public class CostDealerBillDetailServiceImpl implements CostDealerBillDetailService {

  @Autowired
  private CostDealerBillDetailRepository costDealerBillDetailRepository;
  @Autowired
  private MaterialVoService materialVoService;
  /**
   * 明细创建
   * @param billDetail
   */
  @Override
  @Transactional
  public void createBatch(Set<CostDealerBillDetailEntity> billDetail) {
    this.validateCreate(billDetail);
    costDealerBillDetailRepository.saveBatch(billDetail);
  }

  /**
   * 验证
   * @param billDetail
   */
  private void validateCreate(Set<CostDealerBillDetailEntity> billDetail) {
    Validate.isTrue(CollectionUtils.isNotEmpty(billDetail), "创建明细时，明细数据不能为空");
    for(CostDealerBillDetailEntity item : billDetail) {
      Validate.notBlank(item.getPayType(), "创建明细时，上账类型不能为空");
      //上账类型（1.货补2.折扣）
      //如果条件成立，说明类型1是货补，则需要校验物料
      if (item.getPayType().equals("1")) {
        Validate.notBlank(item.getMaterialCode(), "物料编码不能为空");
        MaterialDimensionVo material = materialVoService.findByMaterialCode(item.getMaterialCode());
        Validate.notNull(material, "物料不存在，请检查");
        Validate.notBlank(item.getMaterialName(), "物料名称不能为空");
        Validate.isTrue(item.getMaterialName().equals(item.getMaterialName()), "物料名称不一致，请检查");
        Validate.isTrue(item.getMaterialCode() == null || item.getMaterialCode().length() < 128, "物料编码,在进行添加时填入值超过了限定长度(128)，请检查!");
        Validate.isTrue(item.getMaterialName() == null || item.getMaterialName().length() < 255, "物料名称,在进行添加时填入值超过了限定长度(255)，请检查!");
      }
      Validate.notNull(item.getAmount(), "上账费用不能为空");
      Validate.isTrue(item.getAmount() == null || item.getAmount().compareTo(BigDecimal.ZERO) > 0, "上账费用不能小于0，请检查!");
    }
  }
}
