package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerBillDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerBillRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:33
 */
@Slf4j
@Service
public class CostDealerBillServiceImpl implements CostDealerBillService {

  @Autowired
  private CostDealerBillRepository costDealerBillRepository;
  @Autowired
  private CostDealerBillDetailService costDealerBillDetailService;
  @Autowired
  private DealerVoService dealerVoService;
  @Autowired
  private CostDealerService costDealerService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private CostDealerDetailService costDealerDetailService;

  /**
   * 创建
   * @param dealerBills
   * @return
   */
  @Override
  @Transactional
  public void create(List<CostDealerDetailEntity> dealerBills) {
    Validate.isTrue(CollectionUtils.isNotEmpty(dealerBills), "创建上账数据时，数据不能为空");
    for(CostDealerDetailEntity dealerBill : dealerBills) {
      this.validateCreate(dealerBill);
      Set<CostDealerBillDetailEntity> billDetail = dealerBill.getBillDetail();
      BigDecimal amount = BigDecimal.ZERO;
      CostDealerEntity dbDealer = costDealerService.findByDealerCode(dealerBill.getDealerCode());
      for (CostDealerBillDetailEntity item : billDetail) {
        amount = amount.add(item.getAmount());
      }
      BigDecimal billedFee = dbDealer.getBilledFee() == null ? BigDecimal.ZERO : dbDealer.getBilledFee();
      dealerBill.setBilledFee(billedFee.add(amount));
      Date date = new Date();
      String loginAccountName = loginUserService.getLoginAccountName();
      dealerBill.setCreateAccount(loginAccountName);
      dealerBill.setCreateTime(date);
      dealerBill.setModifyAccount(loginAccountName);
      dealerBill.setModifyTime(date);
      //费用类型（1.分利；2.上账）
      dealerBill.setCostType(2);
      this.costDealerBillRepository.save(dealerBill);
      //上账明细
      if (!CollectionUtils.isEmpty(billDetail)) {
        billDetail.stream().forEach(item -> item.setCostDealerBillId(dealerBill.getId()));
        this.costDealerBillDetailService.createBatch(billDetail);
      }
      //处理未上账和已上账
      BigDecimal unBilledFee = dbDealer.getUnBilledFee() == null ? BigDecimal.ZERO : dbDealer.getUnBilledFee();
      dbDealer.setBilledFee(billedFee.add(amount));
      dbDealer.setUnBilledFee(unBilledFee.subtract(amount));
      costDealerService.update(dbDealer);

      Page<CostDealerDetailEntity> costDealerDetail = costDealerDetailService.findByCostDealerId(dbDealer.getId(), PageRequest.of(0, 10000));
      Validate.isTrue(CollectionUtils.isNotEmpty(costDealerDetail.getRecords()), "经销商费用明细不能为空");
      this.updateDealerDetail(costDealerDetail.getRecords(), amount);
    }
  }

  /**
   * 处理经销商费用明细
   * @param records
   * @param amount
   */
  private void updateDealerDetail(List<CostDealerDetailEntity> records, BigDecimal amount) {
    for(CostDealerDetailEntity detail : records){
      //未上账<=amount
      if(detail.getUnBilledFee().compareTo(amount) < 1){
        detail.setUnBilledFee(BigDecimal.ZERO);
        detail.setBillState(2);
        detail.setBilledFee(detail.getBilledFee().add(detail.getUnBilledFee()));
        amount = amount.subtract(detail.getUnBilledFee());
        costDealerDetailService.update(detail);
        continue;
      }
      //未上账>amount
      if(detail.getUnBilledFee().compareTo(amount) == 1){
        detail.setUnBilledFee(detail.getUnBilledFee().subtract(amount));
        detail.setBillState(3);
        detail.setBilledFee(detail.getBilledFee().add(amount));
        costDealerDetailService.update(detail);
        break;
      }
    }
  }

  /**
   * 创建验证
   * @param dealerBill
   */
  private void validateCreate(CostDealerDetailEntity dealerBill) {
    Validate.notNull(dealerBill, "创建时数据不能为空");
    Validate.isTrue(StringUtils.isBlank(dealerBill.getId()), "创建时数据主键不能有值");
    Validate.notBlank(dealerBill.getDealerCode(), "经销商编码不能为空");
    DealerVo dealer = dealerVoService.findByCustomerCode(dealerBill.getDealerCode());
    Validate.notNull(dealer, "经销商不存在，请检查");
    CostDealerEntity byDealerCode = costDealerService.findByDealerCode(dealerBill.getDealerCode());
    BigDecimal billedFee = byDealerCode.getUnBilledFee() == null ? BigDecimal.ZERO : byDealerCode.getUnBilledFee();
    BigDecimal amount = BigDecimal.ZERO;
    if(!CollectionUtils.isEmpty(dealerBill.getBillDetail())){
      for(CostDealerBillDetailEntity item : dealerBill.getBillDetail()){
        Validate.notNull(item.getAmount(), "上账费用不能为空!");
        //货补
        if(1 == dealerBill.getBillType()) {
          amount = amount.add(item.getAmount());
        }
        //折扣
        if(2 == dealerBill.getBillType()) {
          Validate.isTrue(item.getAmount().compareTo(billedFee) != 1, "费用余额不足");
        }
      }
    }
    //货补
    if(1 == dealerBill.getBillType()){
      Validate.isTrue(amount.compareTo(billedFee) != 1, "费用余额不足");
    }
    Validate.notBlank(dealerBill.getSourceCode(), "来源不能为空");
    Validate.isTrue(dealerBill.getDealerCode() == null || dealerBill.getDealerCode().length() < 128 , "经销商编码,在进行添加时填入值超过了限定长度(128)，请检查!");
    Validate.isTrue(dealerBill.getSourceCode() == null || dealerBill.getSourceCode().length() < 128 , "来源编码,在进行添加时填入值超过了限定长度(128)，请检查!");
  }
}
