package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerBillVoRepository;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerBillDto;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostDealerBillVoService;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDealerBillVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:33
 */
@Slf4j
@Service
public class CostDealerBillVoServiceImpl implements CostDealerBillVoService {

  @Autowired
  private CostDealerBillVoRepository costDealerBillVoRepository;

  /**
   * 多条件分页查询
   * @param costDealerBillDto
   * @param pageable
   * @return
   */
  @Override
  public Page<CostDealerBillVo> findByConditions(CostDealerBillDto costDealerBillDto, Pageable pageable) {
    if(costDealerBillDto == null){
      return new Page<>();
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    costDealerBillDto.setTenantCode(TenantUtils.getTenantCode());
    return costDealerBillVoRepository.findByConditions(costDealerBillDto, pageable);
  }
}
