package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerDetailVoRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDealerDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.stream.Collectors;

/**
 * 经销商费用明细接口实现
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:27
 */
@Service
public class CostDealerDetailVoServiceImpl implements CostDealerDetailVoService {

  @Autowired
  private CostDealerDetailVoRepository costDealerDetailVoRepository;
  /**
   * 多条件分页查询
   * @param costDealerDetailDto
   * @param pageable
   * @return
   */
  @Override
  public Page<CostDealerDetailVo> findByConditions(CostDealerDetailDto costDealerDetailDto, Pageable pageable) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    costDealerDetailDto.setTenantCode(TenantUtils.getTenantCode());
    Page<CostDealerDetailVo> page = costDealerDetailVoRepository.findByConditions(costDealerDetailDto, pageable);
    page.getRecords().forEach(item ->{
      if (!CollectionUtils.isEmpty(item.getParticipatorTagVos())) {
        item.setTag(item.getParticipatorTagVos()
            .stream()
            .map(ParticipatorTagVo::getTagDescription)
            .collect(Collectors.joining("，")));
      }
    });
    return page;
  }
}
