package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDetailVoRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDetailVoService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/2 14:18
 */
@Service
public class CostDetailVoServiceImpl implements CostDetailVoService {

  @Autowired
  private CostDetailVoRepository costDetailVoRepository;
  @Autowired
  private AgreementVoService agreementVoService;

  @Autowired
  private LoginUserService loginUserService;

  @Autowired
  private ParticipatorVoService participatorVoService;

  @Autowired
  private CostDealerDetailService costDealerDetailService;

  @Autowired
  private CostTerminalDetailService costTerminalDetailService;

  /**
   * 多条件分页查询
   * @param yearAndMonth
   * @param type
   * @param pageable
   * @return
   */
  @Override
  public Page<CostDetailVo> findByConditions(String participatorCode, String participatorType, String yearAndMonth, Integer type, Pageable pageable) {
    if(StringUtils.isBlank(participatorCode) || StringUtils.isBlank(participatorType) || StringUtils.isBlank(yearAndMonth)){
      return new Page<>();
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<CostDetailVo> page = new Page<>();
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)){
      //明细
      page = costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndDealer(participatorCode, yearAndMonth, type, pageable);
      if(page != null && !CollectionUtils.isEmpty(page.getRecords())){
        for(CostDetailVo vo : page.getRecords()) {
          //费用类型（1.分利；2.上账; 3.积分商品兑换; 4.核销）
          if(1 == vo.getCostType()) {
            LoginUserAgreementDto dto = new LoginUserAgreementDto();
            dto.setTerminalCode(participatorCode);
            dto.setTemplateCodes(Lists.newArrayList(vo.getTemplateCode()));
            List<AgreementVo> agreements = this.agreementVoService.findByConditions(dto);
            if (!CollectionUtils.isEmpty(agreements)) {
              vo.setTemplateCode(agreements.get(0).getTemplateCode());
              vo.setTemplateName(agreements.get(0).getBelongTemplate());
            }
          }
          //BillType上账类型（1.货补2.折扣）
          if(2 == vo.getCostType() && 1 == vo.getBillType()) {
            vo.setAgreementName("品牌商上账费用(货补上账)");
          }
          if(2 == vo.getCostType() && 2 == vo.getBillType()) {
            vo.setAgreementName("品牌商上账费用(折扣上账)");
          }
          if (3 == vo.getCostType()) {
            vo.setAgreementName("积分商品兑换");
          }
        }
      }
    }
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)){
      //明细
      page = costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndTerminal(participatorCode, yearAndMonth, type, pageable);
      if(page != null && !CollectionUtils.isEmpty(page.getRecords())){
        for(CostDetailVo vo : page.getRecords()) {
          //费用类型（1.分利；2.上账）
          if (1 == vo.getCostType()) {
            LoginUserAgreementDto dto = new LoginUserAgreementDto();
            dto.setTerminalCode(participatorCode);
            dto.setTemplateCodes(Lists.newArrayList(vo.getTemplateCode()));
            List<AgreementVo> agreements = this.agreementVoService.findByConditions(dto);
            if (!CollectionUtils.isEmpty(agreements)) {
              vo.setTemplateCode(agreements.get(0).getTemplateCode());
              vo.setTemplateName(agreements.get(0).getBelongTemplate());
            }
          }
          if (2 == vo.getCostType()) {
            vo.setAgreementName("费用核销");
          }
          if (3 == vo.getCostType()) {
            vo.setAgreementName("积分商品兑换");
          }
        }
      }
    }
    return page;
  }

  /**
   * 创建费用明细
   * @param dto
   */
  @Override
  @Transactional
  public void create(CostDetailDto dto) {
    LoginUserDetailsForCPS loginUser = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey(loginUser.getUsertype());
    String dictCode = participatorTypeEnum.getDictCode();
    dto.setParticipatorCode(loginUser.getConsumerCode());
    dto.setParticipatorName(loginUser.getConsumerName());
    dto.setParticipatorType(dictCode);
    String consumerCode = loginUser.getConsumerCode();
    Validate.notNull(dto, "新增操作时，入参对象不能为空！");
    if(ParticipatorTypeEnum.DEALER.getDictCode().equals(dictCode)){
      CostDealerEntity dealerEntity = new CostDealerEntity();
      dealerEntity.setDealerCode(dto.getParticipatorCode());
      dealerEntity.setDealerName(dto.getParticipatorName());
      List<ParticipatorVo> list = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(dictCode, consumerCode);
      Validate.notEmpty(list,"未找到指定参与者");
      ParticipatorVo participatorVo = list.stream().filter(item-> Objects.equals(item.getParticipatorType(),dictCode)).findFirst().orElse(null);
      Validate.notNull(participatorVo, "未找到指定参与者！");
      dealerEntity.setChannel(participatorVo.getChannel());
      dealerEntity.setOrgCode(participatorVo.getOrgCode());
      dealerEntity.setOrgName(participatorVo.getOrgName());
      dealerEntity.setPhone(participatorVo.getPhone());
      CostDealerDetailEntity dealerDetailEntity = new CostDealerDetailEntity();
      dealerDetailEntity.setInOrOut(dto.getInOrOut());
      //费用类型（1.分利；2.上账；3、兑换）
      dealerDetailEntity.setCostType(dto.getCostType());
      dealerDetailEntity.setSourceCode(dto.getSourceCode());
      dealerDetailEntity.setSourceType(dto.getSourceType());
      dealerDetailEntity.setRecordCode(dto.getRecordCode());
      dealerDetailEntity.setAgreementCode(dto.getAgreementCode());
      dealerDetailEntity.setPolicyName(dto.getPolicyName());
      dealerDetailEntity.setTemplateCode(dto.getTemplateCode());
      dealerDetailEntity.setAmount(dto.getAmount());
      dealerDetailEntity.setBillState(2);
      dealerDetailEntity.setDealerCode(dto.getParticipatorCode());
      dealerDetailEntity.setDealer(dealerEntity);
      dealerDetailEntity.setRebateType(dto.getRebateType());
      //4判断是否有传递奖励
      this.costDealerDetailService.create(dealerDetailEntity);
    }
    //终端
    if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(dictCode)){
      CostTerminalEntity terminalEntity = new CostTerminalEntity();
      terminalEntity.setTerminalCode(dto.getParticipatorCode());
      terminalEntity.setTerminalName(dto.getParticipatorName());
      List<ParticipatorVo> list = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(dictCode, consumerCode);
      Validate.notEmpty(list,"未找到指定参与者");
      ParticipatorVo participatorVo = list.stream().filter(item-> Objects.equals(item.getParticipatorType(),dictCode)).findFirst().orElse(null);
      Validate.notNull(participatorVo, "未找到指定参与者！");
      terminalEntity.setChannel(participatorVo.getChannel());
      terminalEntity.setOrgCode(participatorVo.getOrgCode());
      terminalEntity.setOrgName(participatorVo.getOrgName());
      terminalEntity.setPhone(participatorVo.getPhone());
      CostTerminalDetailEntity terminalDetailEntity = new CostTerminalDetailEntity();
      terminalDetailEntity.setInOrOut(dto.getInOrOut());
      //费用类型（1.分利；2.上账）
      terminalDetailEntity.setCostType(dto.getCostType());
      terminalDetailEntity.setSourceCode(dto.getSourceCode());
      terminalDetailEntity.setSourceType(dto.getSourceType());
      terminalDetailEntity.setRecordCode(dto.getRecordCode());
      terminalDetailEntity.setAgreementCode(dto.getAgreementCode());
      terminalDetailEntity.setTemplateCode(dto.getTemplateCode());
      terminalDetailEntity.setPolicyName(dto.getPolicyName());
      terminalDetailEntity.setAmount(dto.getAmount());
      terminalDetailEntity.setAuditState(1);
      terminalDetailEntity.setTerminalCode(dto.getParticipatorCode());
      terminalDetailEntity.setTerminal(terminalEntity);
      terminalDetailEntity.setRebateType(dto.getRebateType());
      //4判断是否有传递奖励
      this.costTerminalDetailService.create(terminalDetailEntity);
    }
  }

}
