package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.biz.crm.cps.business.reward.cost.local.repository.CostParticipatorRewardStatisticsVoRepository;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostParticipatorRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author hecheng
 * @description: 按参与者统计获利信息
 * @date 2021/8/27 下午8:09
 */
@Service("CostParticipatorRewardStatisticsVoServiceImpl")
public class CostParticipatorRewardStatisticsVoServiceImpl implements CostParticipatorRewardStatisticsVoService {

  @Autowired
  private CostParticipatorRewardStatisticsVoRepository costParticipatorRewardStatisticsVoRepository;

  @Override
  public List<ParticipatorRewardStatisticsVo> findByParticipatorCodes(List<String> participatorCodes) {
    if (CollectionUtils.isEmpty(participatorCodes)) {
      return null;
    }
    return this.costParticipatorRewardStatisticsVoRepository.findByParticipatorCodes(participatorCodes);
  }
}
