package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.biz.crm.cps.business.reward.cost.local.repository.CostScanCodeRewardStatisticsVoRepository;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostScanCodeRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author hecheng
 * @description: 扫码统计汇总收益
 * @date 2021/8/27 下午8:24
 */
@Service("CostScanCodeRewardStatisticsVoServiceImpl")
public class CostScanCodeRewardStatisticsVoServiceImpl implements CostScanCodeRewardStatisticsVoService {

  @Autowired
  private CostScanCodeRewardStatisticsVoRepository costScanCodeRewardStatisticsVoRepository;

  @Override
  public List<ScanCodeRewardStatisticsVo> findByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
    if (StringUtils.isBlank(participatorCode) || CollectionUtils.isEmpty(recordCodes)) {
      return null;
    }
    return this.costScanCodeRewardStatisticsVoRepository.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
  }
}
