package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostTerminalBillRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalBillService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.cost.sdk.common.CostCodeConstant;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:33
 */
@Service
public class CostTerminalBillServiceImpl implements CostTerminalBillService {

  @Autowired
  private CostTerminalBillRepository costTerminalBillRepository;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private CostTerminalService costTerminalService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private CostDealerDetailService costDealerDetailService;
  @Autowired
  private CostDealerService costDealerService;
  @Autowired
  private CostTerminalDetailService costTerminalDetailService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired
  private DealerVoService dealerVoService;


  /**
   * 创建上账
   * @param terminalBillEntity
   * @return
   */
  @Override
  @Transactional
  public CostTerminalDetailEntity create(CostTerminalDetailEntity terminalBillEntity) {
    List<TerminalVo> terminalVos = this.validateCreate(terminalBillEntity);
    TerminalVo terminalVo = terminalVos.get(0);
    CostTerminalDetailEntity costTerminalBillEntity = nebulaToolkitService.copyObjectByWhiteList(terminalVo, CostTerminalDetailEntity.class, HashSet.class, ArrayList.class);
    costTerminalBillEntity.setId(null);
    costTerminalBillEntity.setAmount(terminalBillEntity.getAmount());
    costTerminalBillEntity.setReviewStatus(1);
    CostTerminalEntity costTerminalEntity = costTerminalService.findByTerminalCode(terminalBillEntity.getTerminalCode());
    costTerminalBillEntity.setUnAuditFee(costTerminalEntity.getUnAuditFee());
    String loginAccountName = loginUserService.getLoginAccountName();
    Date date = new Date();
    costTerminalBillEntity.setSubmitTime(date);
    costTerminalBillEntity.setCreateAccount(loginAccountName);
    costTerminalBillEntity.setCreateTime(date);
    costTerminalBillEntity.setModifyAccount(loginAccountName);
    costTerminalBillEntity.setModifyTime(date);
    //费用类型（1.分利；2.上账）
    costTerminalBillEntity.setCostType(2);
    List<String> list = generateCodeService.generateCode(CostCodeConstant.COST_FLOW, 1);
    costTerminalBillEntity.setSourceCode(list.get(0));
    costTerminalBillEntity.setCode(list.get(0));
    costTerminalBillEntity.setInOrOut(2);
    costTerminalBillEntity.setRebateType("终端申请核销");
    costTerminalBillRepository.save(costTerminalBillEntity);
    Page<CostTerminalDetailEntity> costTerminalDetail = costTerminalDetailService.findByCostTerminalId(costTerminalEntity.getId(), PageRequest.of(0, 10000));
    Validate.isTrue(CollectionUtils.isNotEmpty(costTerminalDetail.getRecords()), "经销商费用明细不能为空");
    this.updateTerminalDetail(costTerminalDetail.getRecords(), terminalBillEntity.getAmount());
    return costTerminalBillEntity;
  }

  /**
   * 处理终端费用明细
   * @param records
   * @param amount
   */
  private void updateTerminalDetail(List<CostTerminalDetailEntity> records, BigDecimal amount) {
    for(CostTerminalDetailEntity detail : records){
      //未上账<=amount
      if(detail.getUnAuditFee().compareTo(amount) < 1){
        detail.setUnAuditFee(BigDecimal.ZERO);
        detail.setAuditState(3);
        detail.setAuditedFee(detail.getAuditedFee().add(detail.getUnAuditFee()));
        amount = amount.subtract(detail.getUnAuditFee());
        costTerminalDetailService.update(detail);
        continue;
      }
      //未上账>amount
      if(detail.getUnAuditFee().compareTo(amount) == 1){
        detail.setUnAuditFee(detail.getUnAuditFee().subtract(amount));
        detail.setAuditState(2);
        detail.setAuditedFee(detail.getAuditedFee().add(amount));
        costTerminalDetailService.update(detail);
        break;
      }
    }
  }

  /**
   * 根据经销商编码查询
   * @param dealerCode
   * @param reviewStatus
   * @param pageable
   * @return
   */
  @Override
  public Page<CostTerminalDetailEntity> findByDealerCode(String dealerCode, Integer reviewStatus, Pageable pageable) {
    if(StringUtils.isBlank(dealerCode)){
      return new Page<>();
    }
    List<String> terminalCodes = terminalVoService.findByExternalIdentifier(dealerCode);
    if(CollectionUtils.isEmpty(terminalCodes)){
      return new Page<>();
    }
    Page<CostTerminalDetailEntity> page = costTerminalBillRepository.findByReviewStatusAndTerminalCodes(reviewStatus, terminalCodes, pageable);
    return page;
  }

  /**
   * 批量审批
   * @param ids
   */
  @Override
  @Transactional
  public void approve(List<String> ids, Integer reviewStatus, String dealerCode) {

    Validate.notEmpty(ids, "批量审批时，数据不能为空");
    Validate.notNull(reviewStatus, "批量审批时,审批状态不能为空");
    List<String> terminalCodes = terminalVoService.findByExternalIdentifier(dealerCode);
    for(String id : ids){
      CostTerminalDetailEntity entity = costTerminalBillRepository.getById(id);
      Validate.notNull(entity, "批量审批时,未找到对应数据，请检查");
      Validate.isTrue(entity.getReviewStatus() != 2, "申请已审批，请勿重复审批");
      Validate.isTrue(terminalCodes.contains(entity.getTerminalCode()), "无审批该申请权限");
      //审核状态(1.待审核2.通过3.驳回)
      //通过
      if(reviewStatus == 2){
        entity.setReviewStatus(2);
        entity.setAuditTime(new Date());
        entity.setUnAuditFee(entity.getUnAuditFee().subtract(entity.getAmount()));
        //终端处理
        CostTerminalEntity terminalEntity = costTerminalService.findByTerminalCode(entity.getTerminalCode());
        Validate.isTrue(terminalEntity.getUnAuditFee().compareTo(entity.getAmount()) != -1, "核销金额不能超过未核销金额");
        BigDecimal auditedFee = terminalEntity.getAuditedFee() == null ? BigDecimal.ZERO : terminalEntity.getAuditedFee();
        BigDecimal unAuditFee = terminalEntity.getUnAuditFee() == null ? BigDecimal.ZERO : terminalEntity.getUnAuditFee();
        terminalEntity.setAuditedFee(auditedFee.add(entity.getAmount()));
        terminalEntity.setUnAuditFee(unAuditFee.subtract(entity.getAmount()));
        terminalEntity.setModifyTime(new Date());
        terminalEntity.setModifyAccount(loginUserService.getLoginAccountName());
        costTerminalService.update(terminalEntity);
        //经销商处理
        CostDealerDetailEntity dealerDetailEntity = new CostDealerDetailEntity();
        List<String> list = generateCodeService.generateCode(CostCodeConstant.COST_FLOW, 1);
        dealerDetailEntity.setCode(list.get(0));
        dealerDetailEntity.setSourceType("终端核销流转");
        dealerDetailEntity.setCostType(4);
        dealerDetailEntity.setSourceCode(entity.getCode());
        dealerDetailEntity.setAmount(entity.getAmount());
        dealerDetailEntity.setBillState(2);
        dealerDetailEntity.setInOrOut(2);
        dealerDetailEntity.setRebateType("终端核销");
        //终端关联经销商
        CostDealerEntity dealer = costDealerService.findByDealerCode(dealerCode);
        if(dealer == null){
          DealerVo dealerVo = dealerVoService.findByCustomerCode(dealerCode);
          dealer = nebulaToolkitService.copyObjectByWhiteList(dealerVo, CostDealerEntity.class, HashSet.class, ArrayList.class);
          dealer.setDealerCode(dealerVo.getCustomerCode());
          dealer.setDealerName(dealerVo.getCustomerName());
          dealer.setPhone(dealerVo.getCustomerContact());
          dealer.setChannel(dealerVo.getChannelCode());
          dealer.setTerminalCirculationFee(BigDecimal.ZERO);
          dealer.setUnBilledFee(BigDecimal.ZERO);
          dealer.setBilledFee(BigDecimal.ZERO);
          dealer.setTotalAmount(BigDecimal.ZERO);
          costDealerService.create(dealer);
        }
        Validate.notNull(dealer, "未找到对应的经销商费用信息，请检查");
        BigDecimal terminalCirculationFee = dealer.getTerminalCirculationFee() == null ? BigDecimal.ZERO : dealer.getTerminalCirculationFee();
        dealer.setTerminalCirculationFee(terminalCirculationFee.add(entity.getAmount()));
        dealerDetailEntity.setDealer(dealer);
        dealerDetailEntity.setDealerCode(dealer.getDealerCode());
        costDealerDetailService.create(dealerDetailEntity);
      }
      //驳回
      if(reviewStatus == 3){
        entity.setReviewStatus(3);
        entity.setRejectTime(new Date());
      }
      entity.setModifyTime(new Date());
      entity.setModifyAccount(loginUserService.getLoginAccountName());
      costTerminalBillRepository.saveOrUpdate(entity);
    }
  }

  /**
   * 创建验证
   * @param terminalBillEntity
   */
  private List<TerminalVo> validateCreate(CostTerminalDetailEntity terminalBillEntity) {
    Validate.notNull(terminalBillEntity, "创建时数据不能为空");
    Validate.notBlank(terminalBillEntity.getTerminalCode(), "终端编码不能为空");
    List<TerminalVo> byTerminalCodes = terminalVoService.findByTerminalCodes(Arrays.asList(terminalBillEntity.getTerminalCode()));
    Validate.notEmpty(byTerminalCodes, "终端不存在，请检查");
    Validate.notNull(terminalBillEntity.getAmount(), "核销金额不能为空");

    CostTerminalEntity byTerminalCode = costTerminalService.findByTerminalCode(terminalBillEntity.getTerminalCode());
    //待审核金额汇总
    BigDecimal bill = costTerminalBillRepository.sumByReviewStatusAndTerminalCode(1, terminalBillEntity.getTerminalCode());
    Validate.isTrue((byTerminalCode.getUnAuditFee().subtract(bill == null ? BigDecimal.ZERO : bill)).compareTo(terminalBillEntity.getAmount()) != -1, "本次申请的核销金额不能超过未核销金额");
    Validate.isTrue(terminalBillEntity.getTerminalCode() == null || terminalBillEntity.getTerminalCode().length() < 128 , "终端编码,在进行添加时填入值超过了限定长度(128)，请检查!");
    return byTerminalCodes;
  }
}
