package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorTagVo;
import com.biz.crm.cps.business.reward.cost.local.repository.CostTerminalBillVoRepository;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalBillDto;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostTerminalBillVoService;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostTerminalBillVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.stream.Collectors;

/**
 * @Author: zengxingwang
 * @Date: 2021/8/21 10:33
 */
@Slf4j
@Service
public class CostTerminalBillVoServiceImpl implements CostTerminalBillVoService {

  @Autowired
  private CostTerminalBillVoRepository costTerminalBillVoRepository;

  /**
   * 多条件分页查询
   * @param costTerminalBillDto
   * @param pageable
   * @return
   */
  @Override
  public Page<CostTerminalBillVo> findByConditions(CostTerminalBillDto costTerminalBillDto, Pageable pageable) {
    if(costTerminalBillDto == null){
      return new Page<>();
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    costTerminalBillDto.setTenantCode(TenantUtils.getTenantCode());
    Page<CostTerminalBillVo> conditions = costTerminalBillVoRepository.findByConditions(costTerminalBillDto, pageable);
    conditions.getRecords().forEach(item ->{
      if (!CollectionUtils.isEmpty(item.getParticipatorTagVos())) {
        item.setTag(item.getParticipatorTagVos()
                .stream()
                .map(ParticipatorTagVo::getTagDescription)
                .collect(Collectors.joining("，")));
      }
    });
    return conditions;
  }
}
