package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.repository.CostTerminalDetailVoRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostTerminalDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 终端费用明细接口实现
 * @Author: zengxingwang
 * @Date: 2021/11/16 16:27
 */
@Service
public class CostTerminalDetailVoServiceImpl implements CostTerminalDetailVoService {

  @Autowired
  private CostTerminalDetailVoRepository costTerminalDetailVoRepository;
  /**
   * 多条件分页查询
   * @param dto
   * @param pageable
   * @return
   */
  @Override
  public Page<CostTerminalDetailVo> findByConditions(CostTerminalDetailDto dto, Pageable pageable) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto.setTenantCode(TenantUtils.getTenantCode());
    return costTerminalDetailVoRepository.findByConditions(dto, pageable);
  }
}
