package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.biz.crm.cps.business.reward.cost.local.repository.CostTriggerObjectStatisticsVoRepository;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostTriggerObjectStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author hecheng
 * @description: 触发对象 获利统计实现
 * @date 2021/9/2 下午6:47
 */
@Service("CostTriggerObjectStatisticsVoServiceImpl")
public class CostTriggerObjectStatisticsVoServiceImpl implements CostTriggerObjectStatisticsVoService {
  @Autowired
  private CostTriggerObjectStatisticsVoRepository triggerObjectStatisticsVoRepository;

  @Override
  public List<TriggerObjectRewardStatisticsVo> findByTriggerActionAndTriggerObjects(String triggerAction, List<String> triggerObjects) {
    if (StringUtils.isBlank(triggerAction) || CollectionUtils.isEmpty(triggerObjects)) {
      return null;
    }
    return this.triggerObjectStatisticsVoRepository.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
  }
}
