package com.biz.crm.cps.business.reward.cost.local.service.observer;

import com.biz.crm.cps.business.reward.sdk.service.observer.ComputeTypeMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardComputeTypeMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * @author hecheng
 * @description: 费用定额算法挂载
 * @date 2021/8/26 下午5:50
 */
@Component("CostFixedAmountComputeTypeMountRegisterImpl")
public class CostFixedAmountComputeTypeMountRegisterImpl implements RewardComputeTypeMountRegister {

  @Autowired
  @Qualifier("CostRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  @Qualifier("FixedAmountComputeTypeMountRegisterServiceImpl")
  private ComputeTypeMountRegister computeTypeMountRegister;

  @Override
  public String getName() {
    return computeTypeMountRegister.getName();
  }

  @Override
  public String getKey() {
    return computeTypeMountRegister.getKey();
  }

  @Override
  public String getFlag() {
    return computeTypeMountRegister.getFlag();
  }

  @Override
  public String getRewardFlag() {
    return rewardMountRegister.getFlag();
  }
}
