package com.biz.crm.cps.business.reward.cost.local.service.observer;


import com.biz.crm.cps.business.reward.cost.sdk.service.CostScanCodeRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelScanCodeServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 统计扫码获利汇总观察者接口实现
 * @date 2021/8/27 下午7:23
 */
@Component("CostRewardRelScanCodeServiceObserverImpl")
public class CostRewardRelScanCodeServiceObserverImpl implements RewardRelScanCodeServiceObserver {

  @Autowired
  @Qualifier("CostRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  private CostScanCodeRewardStatisticsVoService costScanCodeRewardStatisticsVoService;

  @Override
  public List<RewardRelScanCodeItemVo> onRequestRewardRelScanCodeItems(String participatorCode, List<String> recordCodes) {
    /**
     * 当统计扫码获利事件发生时，红包模块统计扫码对应的获利，以及所有获利的协议模版
     * 1。先查询扫码对应的获利
     * 2。按扫码记录分组 统计扫码对应的所有的协议模版
     * 3。按扫码记录分组 统计扫码对应的获利
     * 4。组装数据
     */
    if (CollectionUtils.isEmpty(recordCodes) || StringUtils.isBlank(participatorCode)) {
      return null;
    }
    List<ScanCodeRewardStatisticsVo> result = this.costScanCodeRewardStatisticsVoService.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    if (CollectionUtils.isEmpty(result)) {
      return null;
    }
    Map<String, List<String>> recordPolicyMap = result.stream()
            .collect(Collectors.groupingBy(ScanCodeRewardStatisticsVo::getRecordCode, Collectors.mapping(ScanCodeRewardStatisticsVo::getPolicyName, Collectors.toList())));
    Map<String, List<String>> recordTemplateMap = result.stream()
            .collect(Collectors.groupingBy(ScanCodeRewardStatisticsVo::getRecordCode, Collectors.mapping(ScanCodeRewardStatisticsVo::getTemplateCode, Collectors.toList())));
    Map<String, List<BigDecimal>> recordSumAmountMap = result.stream()
            .collect(Collectors.groupingBy(ScanCodeRewardStatisticsVo::getRecordCode, Collectors.mapping(ScanCodeRewardStatisticsVo::getAmount, Collectors.toList())));

    List<RewardRelScanCodeItemVo> list = Lists.newArrayList();
    for (String recordCode : recordCodes) {
      RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
      List<String> templateCodes = recordTemplateMap.get(recordCode);
      List<BigDecimal> amountCodes = recordSumAmountMap.get(recordCode);
      List<String> policyNames = recordPolicyMap.get(recordCode);
      if (CollectionUtils.isEmpty(templateCodes)) {
        continue;
      }
      BigDecimal totalAmount = amountCodes.stream().reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
      vo.setName(this.rewardMountRegister.getName());
      vo.setFlag(this.rewardMountRegister.getFlag());
      vo.setKey(this.rewardMountRegister.getKey());
      vo.setAmount(totalAmount);
      RewardRelScanCodeItemVo item = new RewardRelScanCodeItemVo();
      item.setRecordCode(recordCode);
      item.setTemplateCodes(templateCodes);
      item.setPolicyNames(Sets.newHashSet(policyNames));
      item.setRewardStatisticsVo(vo);
      list.add(item);
    }

    return list;
  }
}
