package com.biz.crm.cps.business.reward.cost.local.service.observer;

import com.biz.crm.cps.business.reward.cost.sdk.service.CostTriggerObjectStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelTriggerObjectServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelTriggerObjectItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.TriggerObjectRewardStatisticsVo;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * @author hecheng
 * @description: 统计触发事件 获利汇总观察者接口实现
 * @date 2021/9/2 下午6:36
 */
@Component("CostRewardRelTriggerObjectServiceObserverImpl")
public class CostRewardRelTriggerObjectServiceObserverImpl implements RewardRelTriggerObjectServiceObserver {
  @Autowired
  @Qualifier("CostRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  private CostTriggerObjectStatisticsVoService triggerObjectStatisticsVoService;

  @Override
  public List<RewardRelTriggerObjectItemVo> onRequestRewardRelTriggerObjectItems(String triggerAction, List<String> triggerObjects) {
    if (StringUtils.isBlank(triggerAction) || CollectionUtils.isEmpty(triggerObjects)) {
      return null;
    }
    List<TriggerObjectRewardStatisticsVo> result = this.triggerObjectStatisticsVoService.findByTriggerActionAndTriggerObjects(triggerAction, triggerObjects);
    if (CollectionUtils.isEmpty(result)) {
      result = new LinkedList<>();
    }
    List<RewardRelTriggerObjectItemVo> list = Lists.newArrayList();
    for (String triggerObject : triggerObjects) {
      RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
      TriggerObjectRewardStatisticsVo statisticsVo = result.stream().filter(item -> Objects.equals(triggerObject, item.getTriggerObject())).findFirst().orElse(null);
      vo.setName(this.rewardMountRegister.getName());
      vo.setFlag(this.rewardMountRegister.getFlag());
      vo.setKey(this.rewardMountRegister.getKey());
      vo.setAmount(statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount());
      RewardRelTriggerObjectItemVo item = new RewardRelTriggerObjectItemVo();
      item.setTriggerObject(triggerObject);
      item.setRewardStatisticsVo(vo);
      list.add(item);
    }
    return list;
  }
}
