package com.biz.crm.cps.business.reward.cost.local.service.observer;

import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.sdk.common.enums.RewardRelateTypeEnum;
import com.biz.crm.cps.business.reward.sdk.dto.RewardConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardServiceObserver;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategy;
import com.biz.crm.cps.business.reward.sdk.service.strategy.RewardComputeStrategyHolder;
import com.biz.crm.cps.business.reward.sdk.vo.ComputeCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * 协议金额实现
 *
 * @author yangfan
 */
@Component("CostRewardServiceObserverImpl")
@Slf4j
public class CostRewardServiceObserverImpl implements RewardServiceObserver {

  @Autowired
  @Qualifier("CostRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private RewardComputeStrategyHolder rewardComputeStrategyHolder;
  @Autowired
  private CostDealerDetailService costDealerDetailService;
  @Autowired
  private CostTerminalDetailService costTerminalDetailService;

  @Transactional
  @Override
  public void onCreate(RewardConditionDto item) {
    Validate.notNull(item, "奖励条件信息不能为空！");
    Validate.notBlank(item.getRewardMethodFlag(), "奖励方式不能为空！");
    Validate.notBlank(item.getAwardConditionFlag(), "奖励计算方式不能为空！");
    // 1根据奖励方式判断是否计算
    if (StringUtil.equals(item.getRewardMethodFlag(), rewardMountRegister.getKey())) {
      //2根据计算方式选择策略
      Validate.notNull(rewardComputeStrategyHolder, "奖励计算策略控制器不能为空！");
      RewardComputeStrategy computeStrategy = this.rewardComputeStrategyHolder.getStrategy(item.getAwardConditionFlag());
      Validate.notNull(computeStrategy, "费用奖励计算方式不能为空！");
      ComputeCashVo computeCashVo = computeStrategy.calculate(item);
      BigDecimal amount = computeCashVo.getRecordCash() == null ? BigDecimal.ZERO : computeCashVo.getRecordCash();
      //经销商
      if(ParticipatorTypeEnum.DEALER.getDictCode().equals(item.getAdditionalParticipatorFlag())){
        CostDealerEntity dealerEntity = new CostDealerEntity();
        dealerEntity.setDealerCode(item.getAdditionalParticipatorCode());
        dealerEntity.setDealerName(item.getAdditionalParticipatorName());
        dealerEntity.setChannel(item.getChannel());
        dealerEntity.setOrgCode(item.getOrgCode());
        dealerEntity.setOrgName(item.getOrgName());
        dealerEntity.setPhone(item.getPhone());
        CostDealerDetailEntity dealerDetailEntity = new CostDealerDetailEntity();
        dealerDetailEntity.setInOrOut(1);
        //费用类型（1.分利；2.上账）
        dealerDetailEntity.setCostType(1);
        dealerDetailEntity.setSourceCode(item.getTriggerObject());
        dealerDetailEntity.setSourceType(item.getTriggerAction());
        dealerDetailEntity.setRecordCode(item.getRecordCode());
        dealerDetailEntity.setAgreementCode(item.getAgreementCode());
        dealerDetailEntity.setPolicyName(item.getPolicyName());
        dealerDetailEntity.setTemplateCode(item.getTemplateCode());
        dealerDetailEntity.setAmount(amount);
        dealerDetailEntity.setBillState(2);
        dealerDetailEntity.setDealerCode(item.getAdditionalParticipatorCode());
        dealerDetailEntity.setRebateType(item.getRebateType());
        dealerDetailEntity.setDealer(dealerEntity);
        dealerDetailEntity.setRelateType(StringUtils.EMPTY);
        dealerDetailEntity.setRelateCode(StringUtils.EMPTY);
        if(StringUtils.isNotBlank(item.getAgreementCode())) {
          dealerDetailEntity.setRelateType(RewardRelateTypeEnum.AGREEMENT.getDictCode());
          dealerDetailEntity.setRelateCode(item.getAgreementCode());
        } else if(StringUtils.isNotBlank(item.getActCode())) {
          dealerDetailEntity.setRelateType(RewardRelateTypeEnum.SCAN_ACTIVITY.getDictCode());
          dealerDetailEntity.setRelateCode(item.getActCode());
        }
        //4判断是否有传递奖励
        this.costDealerDetailService.create(dealerDetailEntity);
      }
      //终端
      if(ParticipatorTypeEnum.TERMINAL.getDictCode().equals(item.getAdditionalParticipatorFlag())){
        CostTerminalEntity terminalEntity = new CostTerminalEntity();
        terminalEntity.setTerminalCode(item.getAdditionalParticipatorCode());
        terminalEntity.setTerminalName(item.getAdditionalParticipatorName());
        terminalEntity.setChannel(item.getChannel());
        terminalEntity.setOrgCode(item.getOrgCode());
        terminalEntity.setOrgName(item.getOrgName());
        terminalEntity.setPhone(item.getPhone());
        CostTerminalDetailEntity terminalDetailEntity = new CostTerminalDetailEntity();
        terminalDetailEntity.setInOrOut(1);
        //费用类型（1.分利；2.上账）
        terminalDetailEntity.setCostType(1);
        terminalDetailEntity.setSourceCode(item.getTriggerObject());
        terminalDetailEntity.setSourceType(item.getTriggerAction());
        terminalDetailEntity.setRecordCode(item.getRecordCode());
        terminalDetailEntity.setAgreementCode(item.getAgreementCode());
        terminalDetailEntity.setTemplateCode(item.getTemplateCode());
        terminalDetailEntity.setPolicyName(item.getPolicyName());
        terminalDetailEntity.setAmount(amount);
        terminalDetailEntity.setAuditState(1);
        terminalDetailEntity.setTerminalCode(item.getAdditionalParticipatorCode());
        terminalDetailEntity.setTerminal(terminalEntity);
        terminalDetailEntity.setRebateType(item.getRebateType());
        terminalDetailEntity.setRelateType(StringUtils.EMPTY);
        terminalDetailEntity.setRelateCode(StringUtils.EMPTY);
        if(StringUtils.isNotBlank(item.getAgreementCode())) {
          terminalDetailEntity.setRelateType(RewardRelateTypeEnum.AGREEMENT.getDictCode());
          terminalDetailEntity.setRelateCode(item.getAgreementCode());
        } else if(StringUtils.isNotBlank(item.getActCode())) {
          terminalDetailEntity.setRelateType(RewardRelateTypeEnum.SCAN_ACTIVITY.getDictCode());
          terminalDetailEntity.setRelateCode(item.getActCode());
        }
        //4判断是否有传递奖励
        this.costTerminalDetailService.create(terminalDetailEntity);
      }
    }
  }
}
