package com.biz.crm.cps.business.reward.cost.local.service.observer;

import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardTypeStatisticsServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import java.math.RoundingMode;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import org.springframework.util.CollectionUtils;

/**
 * @author hecheng
 * @description: 费用统计观察者接口实现
 * @date 2021/8/24 下午7:23
 */
@Component("CostRewardTypeStatisticsServiceObserverImpl")
public class CostRewardTypeStatisticsServiceObserverImpl implements RewardTypeStatisticsServiceObserver {

  @Autowired
  @Qualifier("CostRewardMountRegisterServiceImpl")
  private RewardMountRegister rewardMountRegister;
  @Autowired
  private CostDealerDetailService costDealerDetailService;
  @Autowired
  private CostTerminalDetailService costTerminalDetailService;

  @Override
  public RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String participatorCode, List<String> recordCodes) {
    if(StringUtils.isBlank(participatorCode)|| CollectionUtils.isEmpty(recordCodes)){
      return null;
    }
    recordCodes = recordCodes.stream().filter(item->StringUtils.isNotBlank(item)).collect(Collectors.toList());
    RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
    vo.setName(this.rewardMountRegister.getName());
    vo.setFlag(this.rewardMountRegister.getFlag());
    vo.setKey(this.rewardMountRegister.getKey());
    BigDecimal totalDealer = this.costDealerDetailService.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    BigDecimal totalTerminal = this.costTerminalDetailService.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    BigDecimal total = BigDecimal.ZERO;
    total = total.add(totalDealer == null ? BigDecimal.ZERO : totalDealer).add(totalTerminal == null ? BigDecimal.ZERO : totalTerminal);
    vo.setAmount(total.setScale(2, RoundingMode.HALF_UP));
    return vo;
  }

  @Override
  public RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String tenantCode, String triggerAction) {
    if(StringUtils.isBlank(tenantCode)||StringUtils.isBlank(triggerAction)){
      return null;
    }
    RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
    vo.setName(this.rewardMountRegister.getName());
    vo.setFlag(this.rewardMountRegister.getFlag());
    vo.setKey(this.rewardMountRegister.getKey());
    BigDecimal totalDealer = this.costDealerDetailService.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    BigDecimal totalTerminal = this.costTerminalDetailService.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    BigDecimal total = BigDecimal.ZERO;
    total = total.add(totalDealer == null ? BigDecimal.ZERO : totalDealer).add(totalTerminal == null ? BigDecimal.ZERO : totalTerminal);
    vo.setAmount(total.setScale(2, RoundingMode.HALF_UP));
    return vo;
  }
}
