/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.cost.local.service.CostDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"H5\u660e\u7ec6\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/v1/cost/detail"})
public class CostDetailVoController {
    private static final Logger log = LoggerFactory.getLogger(CostDetailVoController.class);
    @Autowired
    private CostDetailVoService costDetailVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CostDetailVo>> findByConditions(@RequestParam @ApiParam(name="yearAndMonth", value="\u5e74\u6708") String yearAndMonth, @RequestParam @ApiParam(name="type", value="(\u4e0d\u4f20:\u5168\u90e8\uff0c1.\u6536\u51652.\u652f\u51fa)") Integer type, @PageableDefault(value=50) Pageable pageable) {
        try {
            LoginUserDetailsForCPS userDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
            ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
            Page<CostDetailVo> result = this.costDetailVoService.findByConditions(userDetails.getConsumerCode(), participatorTypeEnum.getDictCode(), yearAndMonth, type, pageable);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u8d39\u7528\u660e\u7ec6")
    @PostMapping(value={"create"})
    public Result<?> create(@RequestBody @ApiParam(name="CostDetailDto", value="\u521b\u5efa\u8d39\u7528\u660e\u7ec6") CostDetailDto dto) {
        try {
            this.costDetailVoService.create(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

