/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.repository;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostDealerParticipatorRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.cost.local.mapper.CostTerminalParticipatorRewardStatisticsVoMapper;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostParticipatorRewardStatisticsVoRepository {
    @Autowired
    private CostDealerParticipatorRewardStatisticsVoMapper costDealerParticipatorRewardStatisticsVoMapper;
    @Autowired
    private CostTerminalParticipatorRewardStatisticsVoMapper costTerminalParticipatorRewardStatisticsVoMapper;

    public List<ParticipatorRewardStatisticsVo> findByParticipatorCodes(List<String> participatorCodes) {
        List<ParticipatorRewardStatisticsVo> terminal;
        ArrayList<ParticipatorRewardStatisticsVo> result = new ArrayList<ParticipatorRewardStatisticsVo>();
        List<ParticipatorRewardStatisticsVo> dealer = this.costDealerParticipatorRewardStatisticsVoMapper.findByParticipatorCodes(participatorCodes);
        String today = DateUtil.today();
        if (!CollectionUtils.isEmpty(dealer)) {
            List<ParticipatorRewardStatisticsVo> todayAmount = this.costDealerParticipatorRewardStatisticsVoMapper.findTodayAmountByParticipatorCodes(participatorCodes, today, "\u626b");
            Map<String, BigDecimal> map = this.findTodayAmountMap(todayAmount);
            for (ParticipatorRewardStatisticsVo item : dealer) {
                item.setTodayAmount(map.getOrDefault(item.getParticipatorCode(), BigDecimal.ZERO));
            }
            result.addAll(dealer);
        }
        if (!CollectionUtils.isEmpty(terminal = this.costTerminalParticipatorRewardStatisticsVoMapper.findByParticipatorCodes(participatorCodes))) {
            List<ParticipatorRewardStatisticsVo> todayAmount = this.costTerminalParticipatorRewardStatisticsVoMapper.findTodayAmountByParticipatorCodes(participatorCodes, today);
            Map<String, BigDecimal> map = this.findTodayAmountMap(todayAmount);
            for (ParticipatorRewardStatisticsVo item : terminal) {
                item.setTodayAmount(map.getOrDefault(item.getParticipatorCode(), BigDecimal.ZERO));
            }
            result.addAll(terminal);
        }
        return result;
    }

    private Map<String, BigDecimal> findTodayAmountMap(List<ParticipatorRewardStatisticsVo> todayAmount) {
        if (CollectionUtils.isEmpty(todayAmount)) {
            return Maps.newHashMap();
        }
        return todayAmount.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getParticipatorCode()) && Objects.nonNull(a.getTodayAmount())).collect(Collectors.toMap(ParticipatorRewardStatisticsVo::getParticipatorCode, ParticipatorRewardStatisticsVo::getTodayAmount, (a, b) -> a));
    }
}

