/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerBillDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerBillRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CostDealerBillServiceImpl
implements CostDealerBillService {
    private static final Logger log = LoggerFactory.getLogger(CostDealerBillServiceImpl.class);
    @Autowired
    private CostDealerBillRepository costDealerBillRepository;
    @Autowired
    private CostDealerBillDetailService costDealerBillDetailService;
    @Autowired
    private DealerVoService dealerVoService;
    @Autowired
    private CostDealerService costDealerService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private CostDealerDetailService costDealerDetailService;

    @Override
    @Transactional
    public void create(List<CostDealerDetailEntity> dealerBills) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(dealerBills), (String)"\u521b\u5efa\u4e0a\u8d26\u6570\u636e\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (CostDealerDetailEntity dealerBill : dealerBills) {
            this.validateCreate(dealerBill);
            Set<CostDealerBillDetailEntity> billDetail = dealerBill.getBillDetail();
            BigDecimal amount = BigDecimal.ZERO;
            CostDealerEntity dbDealer = this.costDealerService.findByDealerCode(dealerBill.getDealerCode());
            for (CostDealerBillDetailEntity item2 : billDetail) {
                amount = amount.add(item2.getAmount());
            }
            BigDecimal billedFee = dbDealer.getBilledFee() == null ? BigDecimal.ZERO : dbDealer.getBilledFee();
            dealerBill.setBilledFee(billedFee.add(amount));
            Date date = new Date();
            String loginAccountName = this.loginUserService.getLoginAccountName();
            dealerBill.setCreateAccount(loginAccountName);
            dealerBill.setCreateTime(date);
            dealerBill.setModifyAccount(loginAccountName);
            dealerBill.setModifyTime(date);
            dealerBill.setCostType(2);
            this.costDealerBillRepository.save((Object)dealerBill);
            if (!CollectionUtils.isEmpty(billDetail)) {
                billDetail.stream().forEach(item -> item.setCostDealerBillId(dealerBill.getId()));
                this.costDealerBillDetailService.createBatch(billDetail);
            }
            BigDecimal unBilledFee = dbDealer.getUnBilledFee() == null ? BigDecimal.ZERO : dbDealer.getUnBilledFee();
            dbDealer.setBilledFee(billedFee.add(amount));
            dbDealer.setUnBilledFee(unBilledFee.subtract(amount));
            this.costDealerService.update(dbDealer);
            Page<CostDealerDetailEntity> costDealerDetail = this.costDealerDetailService.findByCostDealerId(dbDealer.getId(), (Pageable)PageRequest.of((int)0, (int)10000));
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)costDealerDetail.getRecords()), (String)"\u7ecf\u9500\u5546\u8d39\u7528\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.updateDealerDetail(costDealerDetail.getRecords(), amount);
        }
    }

    private void updateDealerDetail(List<CostDealerDetailEntity> records, BigDecimal amount) {
        for (CostDealerDetailEntity detail : records) {
            if (detail.getUnBilledFee().compareTo(amount) < 1) {
                detail.setUnBilledFee(BigDecimal.ZERO);
                detail.setBillState(2);
                detail.setBilledFee(detail.getBilledFee().add(detail.getUnBilledFee()));
                amount = amount.subtract(detail.getUnBilledFee());
                this.costDealerDetailService.update(detail);
                continue;
            }
            if (detail.getUnBilledFee().compareTo(amount) != 1) continue;
            detail.setUnBilledFee(detail.getUnBilledFee().subtract(amount));
            detail.setBillState(3);
            detail.setBilledFee(detail.getBilledFee().add(amount));
            this.costDealerDetailService.update(detail);
            break;
        }
    }

    private void validateCreate(CostDealerDetailEntity dealerBill) {
        Validate.notNull((Object)((Object)dealerBill), (String)"\u521b\u5efa\u65f6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dealerBill.getId()), (String)"\u521b\u5efa\u65f6\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerBill.getDealerCode(), (String)"\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DealerVo dealer = this.dealerVoService.findByCustomerCode(dealerBill.getDealerCode());
        Validate.notNull((Object)dealer, (String)"\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        CostDealerEntity byDealerCode = this.costDealerService.findByDealerCode(dealerBill.getDealerCode());
        BigDecimal billedFee = byDealerCode.getUnBilledFee() == null ? BigDecimal.ZERO : byDealerCode.getUnBilledFee();
        BigDecimal amount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(dealerBill.getBillDetail())) {
            for (CostDealerBillDetailEntity item : dealerBill.getBillDetail()) {
                Validate.notNull((Object)item.getAmount(), (String)"\u4e0a\u8d26\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
                if (1 == dealerBill.getBillType()) {
                    amount = amount.add(item.getAmount());
                }
                if (2 != dealerBill.getBillType()) continue;
                Validate.isTrue((item.getAmount().compareTo(billedFee) != 1 ? 1 : 0) != 0, (String)"\u8d39\u7528\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
            }
        }
        if (1 == dealerBill.getBillType()) {
            Validate.isTrue((amount.compareTo(billedFee) != 1 ? 1 : 0) != 0, (String)"\u8d39\u7528\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)dealerBill.getSourceCode(), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dealerBill.getDealerCode() == null || dealerBill.getDealerCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealerBill.getSourceCode() == null || dealerBill.getSourceCode().length() < 128 ? 1 : 0) != 0, (String)"\u6765\u6e90\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

