/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.ParticipatorVoService;
import com.biz.crm.cps.business.participator.sdk.vo.ParticipatorVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDetailVoRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDetailVoService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CostDetailVoServiceImpl
implements CostDetailVoService {
    @Autowired
    private CostDetailVoRepository costDetailVoRepository;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ParticipatorVoService participatorVoService;
    @Autowired
    private CostDealerDetailService costDealerDetailService;
    @Autowired
    private CostTerminalDetailService costTerminalDetailService;

    @Override
    public Page<CostDetailVo> findByConditions(String participatorCode, String participatorType, String yearAndMonth, Integer type, Pageable pageable) {
        List agreements;
        LoginUserAgreementDto dto;
        if (StringUtils.isBlank((CharSequence)participatorCode) || StringUtils.isBlank((CharSequence)participatorType) || StringUtils.isBlank((CharSequence)yearAndMonth)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page<CostDetailVo> page = new Page<CostDetailVo>();
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType) && (page = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndDealer(participatorCode, yearAndMonth, type, pageable)) != null && !CollectionUtils.isEmpty((Collection)page.getRecords())) {
            for (CostDetailVo vo : page.getRecords()) {
                if (1 == vo.getCostType()) {
                    dto = new LoginUserAgreementDto();
                    dto.setTerminalCode(participatorCode);
                    dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
                    agreements = this.agreementVoService.findByConditions(dto);
                    if (!CollectionUtils.isEmpty((Collection)agreements)) {
                        vo.setTemplateCode(((AgreementVo)agreements.get(0)).getTemplateCode());
                        vo.setTemplateName(((AgreementVo)agreements.get(0)).getBelongTemplate());
                    }
                }
                if (2 == vo.getCostType() && 1 == vo.getBillType()) {
                    vo.setAgreementName("\u54c1\u724c\u5546\u4e0a\u8d26\u8d39\u7528(\u8d27\u8865\u4e0a\u8d26)");
                }
                if (2 == vo.getCostType() && 2 == vo.getBillType()) {
                    vo.setAgreementName("\u54c1\u724c\u5546\u4e0a\u8d26\u8d39\u7528(\u6298\u6263\u4e0a\u8d26)");
                }
                if (3 != vo.getCostType()) continue;
                vo.setAgreementName("\u79ef\u5206\u5546\u54c1\u5151\u6362");
            }
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType) && (page = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndTerminal(participatorCode, yearAndMonth, type, pageable)) != null && !CollectionUtils.isEmpty((Collection)page.getRecords())) {
            for (CostDetailVo vo : page.getRecords()) {
                if (1 == vo.getCostType()) {
                    dto = new LoginUserAgreementDto();
                    dto.setTerminalCode(participatorCode);
                    dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
                    agreements = this.agreementVoService.findByConditions(dto);
                    if (!CollectionUtils.isEmpty((Collection)agreements)) {
                        vo.setTemplateCode(((AgreementVo)agreements.get(0)).getTemplateCode());
                        vo.setTemplateName(((AgreementVo)agreements.get(0)).getBelongTemplate());
                    }
                }
                if (2 == vo.getCostType()) {
                    vo.setAgreementName("\u8d39\u7528\u6838\u9500");
                }
                if (3 != vo.getCostType()) continue;
                vo.setAgreementName("\u79ef\u5206\u5546\u54c1\u5151\u6362");
            }
        }
        return page;
    }

    @Override
    @Transactional
    public void create(CostDetailDto dto) {
        ParticipatorVo participatorVo;
        List list;
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)loginUser.getUsertype());
        String dictCode = participatorTypeEnum.getDictCode();
        dto.setParticipatorCode(loginUser.getConsumerCode());
        dto.setParticipatorName(loginUser.getConsumerName());
        dto.setParticipatorType(dictCode);
        String consumerCode = loginUser.getConsumerCode();
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(dictCode)) {
            CostDealerEntity dealerEntity = new CostDealerEntity();
            dealerEntity.setDealerCode(dto.getParticipatorCode());
            dealerEntity.setDealerName(dto.getParticipatorName());
            list = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(dictCode, consumerCode);
            Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005", (Object[])new Object[0]);
            participatorVo = list.stream().filter(item -> Objects.equals(item.getParticipatorType(), dictCode)).findFirst().orElse(null);
            Validate.notNull((Object)participatorVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005\uff01", (Object[])new Object[0]);
            dealerEntity.setChannel(participatorVo.getChannel());
            dealerEntity.setOrgCode(participatorVo.getOrgCode());
            dealerEntity.setOrgName(participatorVo.getOrgName());
            dealerEntity.setPhone(participatorVo.getPhone());
            CostDealerDetailEntity dealerDetailEntity = new CostDealerDetailEntity();
            dealerDetailEntity.setInOrOut(dto.getInOrOut());
            dealerDetailEntity.setCostType(dto.getCostType());
            dealerDetailEntity.setSourceCode(dto.getSourceCode());
            dealerDetailEntity.setSourceType(dto.getSourceType());
            dealerDetailEntity.setRecordCode(dto.getRecordCode());
            dealerDetailEntity.setAgreementCode(dto.getAgreementCode());
            dealerDetailEntity.setPolicyName(dto.getPolicyName());
            dealerDetailEntity.setTemplateCode(dto.getTemplateCode());
            dealerDetailEntity.setAmount(dto.getAmount());
            dealerDetailEntity.setBillState(2);
            dealerDetailEntity.setDealerCode(dto.getParticipatorCode());
            dealerDetailEntity.setDealer(dealerEntity);
            dealerDetailEntity.setRebateType(dto.getRebateType());
            this.costDealerDetailService.create(dealerDetailEntity);
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(dictCode)) {
            CostTerminalEntity terminalEntity = new CostTerminalEntity();
            terminalEntity.setTerminalCode(dto.getParticipatorCode());
            terminalEntity.setTerminalName(dto.getParticipatorName());
            list = this.participatorVoService.findByParticipatorTypeAndParticipatorCode(dictCode, consumerCode);
            Validate.notEmpty((Collection)list, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005", (Object[])new Object[0]);
            participatorVo = list.stream().filter(item -> Objects.equals(item.getParticipatorType(), dictCode)).findFirst().orElse(null);
            Validate.notNull((Object)participatorVo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u53c2\u4e0e\u8005\uff01", (Object[])new Object[0]);
            terminalEntity.setChannel(participatorVo.getChannel());
            terminalEntity.setOrgCode(participatorVo.getOrgCode());
            terminalEntity.setOrgName(participatorVo.getOrgName());
            terminalEntity.setPhone(participatorVo.getPhone());
            CostTerminalDetailEntity terminalDetailEntity = new CostTerminalDetailEntity();
            terminalDetailEntity.setInOrOut(dto.getInOrOut());
            terminalDetailEntity.setCostType(dto.getCostType());
            terminalDetailEntity.setSourceCode(dto.getSourceCode());
            terminalDetailEntity.setSourceType(dto.getSourceType());
            terminalDetailEntity.setRecordCode(dto.getRecordCode());
            terminalDetailEntity.setAgreementCode(dto.getAgreementCode());
            terminalDetailEntity.setTemplateCode(dto.getTemplateCode());
            terminalDetailEntity.setPolicyName(dto.getPolicyName());
            terminalDetailEntity.setAmount(dto.getAmount());
            terminalDetailEntity.setAuditState(1);
            terminalDetailEntity.setTerminalCode(dto.getParticipatorCode());
            terminalDetailEntity.setTerminal(terminalEntity);
            terminalDetailEntity.setRebateType(dto.getRebateType());
            this.costTerminalDetailService.create(terminalDetailEntity);
        }
    }
}

