/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostTerminalDetailRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CostTerminalDetailServiceImpl
implements CostTerminalDetailService {
    private static final Logger log = LoggerFactory.getLogger(CostTerminalDetailServiceImpl.class);
    @Autowired
    private CostTerminalDetailRepository costTerminalDetailRepository;
    @Autowired
    private CostTerminalService costTerminalService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<CostTerminalDetailEntity> findByCostTerminalId(String costTerminalId, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)costTerminalId)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        return this.costTerminalDetailRepository.findByCostTerminalId(costTerminalId, pageable);
    }

    @Override
    @Transactional
    public CostTerminalDetailEntity create(CostTerminalDetailEntity terminalDetailEntity) {
        log.debug("\u65b0\u589e\u8d39\u7528\u6d41\u6c34\u4f20\u5165\u53c2\u6570={}", (Object)terminalDetailEntity);
        this.createForm(terminalDetailEntity);
        CostTerminalEntity terminal = terminalDetailEntity.getTerminal();
        CostTerminalEntity old = this.costTerminalService.findByTerminalCode(terminal.getTerminalCode());
        if (old != null) {
            BigDecimal totalAmount = old.getTotalAmount() == null ? BigDecimal.ZERO : old.getTotalAmount();
            BigDecimal unAuditFee = old.getUnAuditFee() == null ? BigDecimal.ZERO : old.getUnAuditFee();
            totalAmount = totalAmount.add(terminalDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
            unAuditFee = unAuditFee.add(terminalDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
            old.setTotalAmount(totalAmount);
            old.setUnAuditFee(unAuditFee);
            old.setModifyAccount(this.loginUserService.getLoginAccountName());
            old.setModifyTime(new Date());
            this.costTerminalService.update(old);
            terminalDetailEntity.setCostTerminalId(old.getId());
        } else {
            terminal.setAuditedFee(terminalDetailEntity.getAuditedFee());
            terminal.setTotalAmount(terminalDetailEntity.getAmount());
            terminal.setUnAuditFee(terminalDetailEntity.getAmount());
            CostTerminalEntity returnEntity = this.costTerminalService.create(terminal);
            terminalDetailEntity.setCostTerminalId(returnEntity.getId());
        }
        this.costTerminalDetailRepository.saveOrUpdate((Object)terminalDetailEntity);
        return terminalDetailEntity;
    }

    private CostTerminalDetailEntity createForm(CostTerminalDetailEntity terminalDetailEntity) {
        this.createValidation(terminalDetailEntity);
        if (Objects.nonNull(this.generateCodeService)) {
            terminalDetailEntity.setCode((String)this.generateCodeService.generateCode("cost_detail_code", 1).get(0));
        }
        CostTerminalEntity terminal = terminalDetailEntity.getTerminal();
        terminal.setTenantCode(TenantUtils.getTenantCode());
        Date date = new Date();
        String loginAccountName = this.loginUserService.getLoginAccountName();
        terminal.setCreateTime(date);
        terminal.setCreateAccount(loginAccountName);
        terminal.setModifyTime(date);
        terminal.setModifyAccount(loginAccountName);
        terminal.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminalDetailEntity.setCreateTime(date);
        terminalDetailEntity.setCreateAccount(loginAccountName);
        terminalDetailEntity.setModifyTime(date);
        terminalDetailEntity.setModifyAccount(loginAccountName);
        CostTerminalEntity lastTerminal = this.costTerminalService.findTop1ByTerminalCode(terminal.getTerminalCode());
        if (lastTerminal != null) {
            BigDecimal auditedFee = lastTerminal.getAuditedFee() == null ? BigDecimal.ZERO : lastTerminal.getAuditedFee();
            terminalDetailEntity.setAuditedFee(auditedFee);
            BigDecimal unAuditFee = lastTerminal.getUnAuditFee() == null ? BigDecimal.ZERO : lastTerminal.getUnAuditFee();
            unAuditFee = unAuditFee.add(terminalDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
            terminalDetailEntity.setUnAuditFee(unAuditFee);
        } else {
            terminalDetailEntity.setAuditedFee(BigDecimal.ZERO);
            terminalDetailEntity.setUnAuditFee(terminalDetailEntity.getAmount());
        }
        return terminalDetailEntity;
    }

    private void createValidation(CostTerminalDetailEntity terminalDetailEntity) {
        Validate.notNull((Object)((Object)terminalDetailEntity), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalDetailEntity.getSourceCode(), (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalDetailEntity.getSourceType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        CostTerminalEntity terminal = terminalDetailEntity.getTerminal();
        Validate.notNull((Object)((Object)terminal), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7ec8\u7aef\u8d39\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((terminalDetailEntity.getSourceCode().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminalDetailEntity.getSourceType().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
        if (StringUtils.isBlank((CharSequence)participatorCode) && CollectionUtils.isEmpty(recordCodes)) {
            return null;
        }
        return this.costTerminalDetailRepository.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    }

    @Override
    public BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)triggerAction)) {
            return null;
        }
        return this.costTerminalDetailRepository.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    }

    @Override
    @Transactional
    public void update(CostTerminalDetailEntity detail) {
        this.updateValidation(detail);
        this.costTerminalDetailRepository.updateById((Object)detail);
    }

    private void updateValidation(CostTerminalDetailEntity terminalDetailEntity) {
        Validate.notNull((Object)((Object)terminalDetailEntity), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalDetailEntity.getId(), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalDetailEntity.getSourceCode(), (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalDetailEntity.getSourceType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((terminalDetailEntity.getSourceCode().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminalDetailEntity.getSourceType().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

