/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerDetailRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CostDealerDetailServiceImpl
implements CostDealerDetailService {
    private static final Logger log = LoggerFactory.getLogger(CostDealerDetailServiceImpl.class);
    @Autowired
    private CostDealerDetailRepository costDealerDetailRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private CostDealerService costDealerService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<CostDealerDetailEntity> findByCostDealerId(String costDealerId, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)costDealerId)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        return this.costDealerDetailRepository.findByCostDealerId(costDealerId, pageable);
    }

    @Override
    @Transactional
    public CostDealerDetailEntity create(CostDealerDetailEntity dealerDetailEntity) {
        log.debug("\u65b0\u589e\u8d39\u7528\u6d41\u6c34\u4f20\u5165\u53c2\u6570={}", (Object)dealerDetailEntity);
        this.createForm(dealerDetailEntity);
        CostDealerEntity dealer = dealerDetailEntity.getDealer();
        CostDealerEntity old = this.costDealerService.findByDealerCode(dealer.getDealerCode());
        if (old != null) {
            BigDecimal terminalCirculationFee;
            BigDecimal totalAmount = old.getTotalAmount() == null ? BigDecimal.ZERO : old.getTotalAmount();
            BigDecimal unBilledFee = old.getUnBilledFee() == null ? BigDecimal.ZERO : old.getUnBilledFee();
            BigDecimal bigDecimal = terminalCirculationFee = old.getTerminalCirculationFee() == null ? BigDecimal.ZERO : old.getTerminalCirculationFee();
            if ("\u7ec8\u7aef\u6838\u9500\u6d41\u8f6c".equals(dealerDetailEntity.getSourceType())) {
                terminalCirculationFee = terminalCirculationFee.add(dealerDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
                old.setTerminalCirculationFee(terminalCirculationFee);
            } else {
                totalAmount = totalAmount.add(dealerDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
                old.setTotalAmount(totalAmount);
            }
            unBilledFee = unBilledFee.add(dealerDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
            old.setUnBilledFee(unBilledFee);
            old.setModifyAccount(this.loginUserService.getLoginAccountName());
            old.setModifyTime(new Date());
            this.costDealerService.update(old);
            dealerDetailEntity.setCostDealerId(old.getId());
        } else {
            dealer.setBilledFee(dealerDetailEntity.getBilledFee());
            dealer.setTerminalCirculationFee(BigDecimal.ZERO);
            dealer.setTotalAmount(dealerDetailEntity.getAmount());
            dealer.setUnBilledFee(dealerDetailEntity.getAmount());
            CostDealerEntity returnEntity = this.costDealerService.create(dealer);
            dealerDetailEntity.setCostDealerId(returnEntity.getId());
        }
        this.costDealerDetailRepository.saveOrUpdate((Object)dealerDetailEntity);
        return dealerDetailEntity;
    }

    private CostDealerDetailEntity createForm(CostDealerDetailEntity dealerDetailEntity) {
        this.createValidation(dealerDetailEntity);
        if (Objects.nonNull(this.generateCodeService)) {
            dealerDetailEntity.setCode((String)this.generateCodeService.generateCode("cost_detail_code", 1).get(0));
        }
        CostDealerEntity dealer = dealerDetailEntity.getDealer();
        dealer.setTenantCode(TenantUtils.getTenantCode());
        Date date = new Date();
        String loginAccountName = this.loginUserService.getLoginAccountName();
        dealer.setCreateTime(date);
        dealer.setCreateAccount(loginAccountName);
        dealer.setModifyTime(date);
        dealer.setModifyAccount(loginAccountName);
        dealer.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dealer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dealerDetailEntity.setCreateTime(date);
        dealerDetailEntity.setCreateAccount(loginAccountName);
        dealerDetailEntity.setModifyTime(date);
        dealerDetailEntity.setModifyAccount(loginAccountName);
        CostDealerEntity lastDealer = this.costDealerService.findTop1ByDealerCode(dealer.getDealerCode());
        if (lastDealer != null) {
            BigDecimal billedFee = lastDealer.getBilledFee() == null ? BigDecimal.ZERO : lastDealer.getBilledFee();
            dealerDetailEntity.setBilledFee(billedFee);
            BigDecimal unBilledFee = lastDealer.getUnBilledFee() == null ? BigDecimal.ZERO : lastDealer.getUnBilledFee();
            unBilledFee = unBilledFee.add(dealerDetailEntity.getAmount()).setScale(4, RoundingMode.HALF_UP);
            dealerDetailEntity.setUnBilledFee(unBilledFee);
        } else {
            dealerDetailEntity.setBilledFee(BigDecimal.ZERO);
            dealerDetailEntity.setUnBilledFee(dealerDetailEntity.getAmount());
        }
        return dealerDetailEntity;
    }

    private void createValidation(CostDealerDetailEntity dealerDetailEntity) {
        Validate.notNull((Object)((Object)dealerDetailEntity), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerDetailEntity.getSourceCode(), (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerDetailEntity.getSourceType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        CostDealerEntity dealer = dealerDetailEntity.getDealer();
        Validate.notNull((Object)((Object)dealer), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u7ecf\u9500\u5546\u8d39\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDealerCode(), (String)"\u7ecf\u9500\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealer.getDealerName(), (String)"\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((dealerDetailEntity.getSourceCode().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealerDetailEntity.getSourceType().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
        if (StringUtils.isBlank((CharSequence)participatorCode) && CollectionUtils.isEmpty(recordCodes)) {
            return null;
        }
        return this.costDealerDetailRepository.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
    }

    @Override
    public BigDecimal sumByTenantCodeAndTriggerAction(String tenantCode, String triggerAction) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)triggerAction)) {
            return null;
        }
        return this.costDealerDetailRepository.sumByTenantCodeAndTriggerAction(tenantCode, triggerAction);
    }

    @Override
    @Transactional
    public void update(CostDealerDetailEntity detail) {
        this.updateValidation(detail);
        this.costDealerDetailRepository.updateById((Object)detail);
    }

    private void updateValidation(CostDealerDetailEntity dealerDetailEntity) {
        Validate.notNull((Object)((Object)dealerDetailEntity), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerDetailEntity.getId(), (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerDetailEntity.getSourceCode(), (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dealerDetailEntity.getSourceType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((dealerDetailEntity.getSourceCode().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u6765\u6e90\u7f16\u53f7\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dealerDetailEntity.getSourceType().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

