/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostTerminalRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalDto;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CostTerminalServiceImpl
implements CostTerminalService {
    private static final Logger log = LoggerFactory.getLogger(CostTerminalServiceImpl.class);
    @Autowired
    private CostTerminalRepository costTerminalRepository;

    @Override
    public Page<CostTerminalEntity> findByConditions(CostTerminalDto costTerminalDto, Pageable pageable) {
        if (costTerminalDto == null) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        costTerminalDto.setTenantCode(TenantUtils.getTenantCode());
        return this.costTerminalRepository.findByConditions(costTerminalDto, pageable);
    }

    @Override
    public CostTerminalEntity findByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        return this.costTerminalRepository.findByTerminalCode(terminalCode);
    }

    @Override
    @Transactional
    public CostTerminalEntity create(CostTerminalEntity terminal) {
        this.createValidate(terminal);
        this.costTerminalRepository.save((Object)terminal);
        return terminal;
    }

    private void createValidate(CostTerminalEntity terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u521b\u5efa\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u521b\u5efa\u65f6\uff0c\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getChannel(), (String)"\u521b\u5efa\u65f6\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostTerminalEntity costTerminalEntity = this.findByTerminalCode(terminal.getTerminalCode());
        Validate.isTrue((costTerminalEntity == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalCode() == null || terminal.getTerminalCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalName() == null || terminal.getTerminalName().length() < 255 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u540d\u79f0,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getChannel() == null || terminal.getChannel().length() < 64 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7f16\u7801,\u5728\u8fdb\u884c\u521b\u5efa\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public CostTerminalEntity update(CostTerminalEntity terminal) {
        this.updateValidate(terminal);
        this.costTerminalRepository.saveOrUpdate((Object)terminal);
        return terminal;
    }

    @Override
    public CostTerminalEntity findTop1ByTerminalCode(String terminalCode) {
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        return this.costTerminalRepository.findTop1ByTerminalCode(terminalCode);
    }

    private void updateValidate(CostTerminalEntity terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u4fee\u6539\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalCode(), (String)"\u4fee\u6539\u65f6\uff0c\u7ecf\u9500\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getTerminalName(), (String)"\u4fee\u6539\u65f6\uff0c\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getChannel(), (String)"\u4fee\u6539\u65f6\uff0c\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostTerminalEntity costTerminalEntity = this.findByTerminalCode(terminal.getTerminalCode());
        Validate.isTrue((costTerminalEntity != null ? 1 : 0) != 0, (String)"\u4fee\u6539\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalCode() == null || terminal.getTerminalCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getTerminalName() == null || terminal.getTerminalName().length() < 255 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((terminal.getChannel() == null || terminal.getChannel().length() < 64 ? 1 : 0) != 0, (String)"\u6e20\u9053\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

